import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/row_widget/bottom_sheet_top_row.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/new_product/new_product_controller.dart';

class SelectedVariantBottomSheet extends StatefulWidget {
  const SelectedVariantBottomSheet({super.key});

  @override
  State<SelectedVariantBottomSheet> createState() =>
      _SelectedVariantBottomSheetState();
}

class _SelectedVariantBottomSheetState
    extends State<SelectedVariantBottomSheet> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<NewProductController>(
      builder: (controller) => SizedBox(
        height: MediaQuery.of(context).size.height,
        child: Column(
          children: [
            BottomSheetTopRow(
              header: MyStrings.variant.tr,
              bgColor: MyColor.white,
            ),
            Expanded(
              child: ListView.builder(
                physics: BouncingScrollPhysics(),
                shrinkWrap: true,
                itemCount: controller.filteredVariants.length,
                itemBuilder: (context, index) {
                  final variants = controller.filteredVariants[index];

                  final isSelected = controller.selectedVariants
                      .any((variant) => variant.id == variants.id);
                  return CustomAppCard(
                    radius: Dimensions.space10,
                    padding: EdgeInsetsDirectional.symmetric(
                        horizontal: 10, vertical: 20),
                    onPressed: () {
                      controller.updateSelectedProduct(variants);
                    },
                    margin: const EdgeInsets.symmetric(
                        vertical: Dimensions.space10),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        Expanded(child: Text(variants.name ?? "")),
                        Icon(
                          isSelected
                              ? Icons.check_circle_outline_outlined
                              : Icons.circle_outlined,
                          color: isSelected
                              ? MyColor.getPrimaryColor()
                              : MyColor.getBodyTextColor(),
                        ),
                      ],
                    ),
                  );
                },
              ),
            ),
          ],
        ),
      ),
    );
  }
}
