import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/image/my_network_image_widget.dart';
import 'package:ovosale/core/app_permission/app_permission.dart';
import 'package:ovosale/core/route/route.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/cart/global_controller.dart';
import 'package:ovosale/data/controller/products/products_controller.dart';
import 'package:ovosale/data/model/product/product_response_model.dart';

class ProductsDetailsListTile extends StatelessWidget {
  final List<ProductsData> productData;
  final List<Detail> productDetails;
  final int index;
  const ProductsDetailsListTile({
    super.key,
    required this.productData,
    required this.index,
    required this.productDetails,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<ProductsController>(
      builder: (controller) => ListTile(
        contentPadding: EdgeInsetsDirectional.zero,
        leading: CustomAppCard(
          height: Dimensions.space100.h,
          width: Dimensions.space60.w,
          radius: Dimensions.space8,
          padding: EdgeInsetsDirectional.all(Dimensions.space4),
          child: MyNetworkImageWidget(
            boxFit: BoxFit.cover,
            imageUrl: productData[index].imageSrc ?? "",
          ),
        ),
        title: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Text(
              productData[index].name ?? "",
              overflow: TextOverflow.ellipsis,
              style: theme.textTheme.headlineSmall
                  ?.copyWith(fontSize: Dimensions.space16.sp),
            ),
            spaceDown(Dimensions.space5),
            Wrap(
              children: [
                Text(
                  productData[index].category?.name ?? "",
                  style: theme.textTheme.bodySmall,
                ),
                Container(
                  margin: EdgeInsetsDirectional.symmetric(
                      horizontal: Dimensions.space4),
                  height: Dimensions.space12.h,
                  width: 1,
                  color: MyColor.getBodyTextColor().withValues(alpha: 0.5),
                ),
                Text(
                  productData[index].brand?.name ?? "",
                  style: theme.textTheme.bodySmall,
                ),
              ],
            ),
            spaceDown(Dimensions.space2),
            Row(
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                Text(
                  '${MyStrings.price.tr} : ',
                  style: theme.textTheme.bodySmall?.copyWith(
                      fontWeight: FontWeight.w600,
                      fontSize: Dimensions.space12.sp),
                ),
                Text(
                  controller.findMinMaxPriceForProduct(
                      productData[index].details ?? []),
                  style: theme.textTheme.bodySmall?.copyWith(
                      fontWeight: FontWeight.w600,
                      fontSize: Dimensions.space12.sp),
                ),
                spaceSide(Dimensions.space4.w),
              ],
            ),
          ],
        ),
        trailing: CustomAppCard(
            onPressed: () {
              if (Get.find<GlobalController>()
                  .checkPermission(featureName: AppPermissions.editProduct)) {
                Get.toNamed(RouteHelper.updateProductScreen,
                    arguments: [productData[index].id.toString()])?.then((v) {
                  controller.getProductData();
                });
              }
            },
            showBorder: false,
            padding: EdgeInsetsDirectional.all(8),
            radius: Dimensions.space8,
            backgroundColor:
                MyColor.getInformationColor().withValues(alpha: .2),
            child: MyAssetImageWidget(
              assetPath: MyIcons.edit,
              isSvg: true,
              height: Dimensions.space15.h,
              width: Dimensions.space16.w,
            )),
      ),
    );
  }
}
