import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/bottom-sheet/custom_bottom_sheet.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/pick_image/pick_image.dart';
import 'package:ovosale/app/components/text-field/custom_drop_down_text_field.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/app/components/text/label_text.dart';
import 'package:ovosale/app/screens/products/new_product_screen.dart';
import 'package:ovosale/app/screens/products/widgets/select_product_variant_bottom_sheet.dart';
import 'package:ovosale/app/screens/products/widgets/selected_attribute_bottomsheet.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/new_product/new_product_controller.dart';

class NewProductsFormStepOne extends StatefulWidget {
  const NewProductsFormStepOne({
    super.key,
  });

  @override
  State<NewProductsFormStepOne> createState() => _NewProductsFormStepOneState();
}

class _NewProductsFormStepOneState extends State<NewProductsFormStepOne> {
  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<NewProductController>(builder: (controller) {
      return Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          LabelTextField(
            labelText: MyStrings.productName.tr,
            hintText: MyStrings.enterProductName.tr,
            controller: controller.productNameController,
            isRequired: true,
            onChanged: (value) {},
            contentPadding: EdgeInsetsDirectional.symmetric(
                vertical: Dimensions.space17.h,
                horizontal: Dimensions.space16.w),
            textInputType: TextInputType.text,
            textInputAction: TextInputAction.done,
            radius: Dimensions.largeRadius,
            validator: (value) {
              if (value!.isEmpty) {
                return MyStrings.fieldErrorMsg.tr;
              } else {
                return null;
              }
            },
          ),
          spaceDown(Dimensions.space16.h),
          LabelTextField(
            labelText: MyStrings.productCode.tr,
            controller: controller.productCodeController,
            onChanged: (value) {},
            contentPadding: EdgeInsetsDirectional.symmetric(
                vertical: Dimensions.space17.h,
                horizontal: Dimensions.space16.w),
            textInputType: TextInputType.text,
            textInputAction: TextInputAction.done,
            radius: Dimensions.largeRadius,
            validator: (value) {
              if (value!.isEmpty) {
                return MyStrings.fieldErrorMsg.tr;
              } else {
                return null;
              }
            },
          ),
          spaceDown(Dimensions.space16.h),
          CustomDropDownTextField(
            selectedValue: controller.selectedBrand,
            onChanged: (value) {
              controller.selectedBrand = value;

              final selectedItem = controller.brands.firstWhere(
                (item) => item.name == value,
              );
              controller.selectedBrandId = selectedItem.id.toString();

              controller.update();
            },
            labelText: MyStrings.selectBrand.tr,
            items: controller.brands.map((item) {
              return DropdownMenuItem(
                value: item.name,
                child: Text(item.name!, style: theme.textTheme.bodySmall),
              );
            }).toList(),
          ),
          spaceDown(Dimensions.space16.h),
          CustomDropDownTextField(
            selectedValue: controller.selectedProductType,
            onChanged: (value) {
              controller.formData.clear();
              controller.selectedProductType = value;
              controller.update();
            },
            labelText: MyStrings.productType.tr,
            items: controller.selectedProductTypeData.map((item) {
              return DropdownMenuItem(
                value: item['name'],
                child:
                    Text(item["name"] ?? "", style: theme.textTheme.bodySmall),
              );
            }).toList(),
          ),
          spaceDown(Dimensions.space16.h),
          CustomDropDownTextField(
            selectedValue: controller.selectedUnit,
            onChanged: (value) {
              controller.selectedUnit = value;
              final selectedItem = controller.units.firstWhere(
                (item) => item.name == value,
              );
              controller.selectedUnitId = selectedItem.id.toString();
              controller.update();
            },
            labelText: MyStrings.selectUnit.tr,
            items: controller.units.map((item) {
              return DropdownMenuItem(
                value: item.name,
                child: Text(item.name!, style: theme.textTheme.bodySmall),
              );
            }).toList(),
          ),
          spaceDown(Dimensions.space16.h),
          CustomDropDownTextField(
            selectedValue: controller.selectedCategory,
            onChanged: (value) {
              controller.selectedCategory = value;
              final selectedItem = controller.categories.firstWhere(
                (item) => item.name == value,
              );
              controller.selectedCategoryId = selectedItem.id.toString();
              controller.update();
            },
            labelText: MyStrings.selectCategory.tr,
            items: controller.categories.map((item) {
              return DropdownMenuItem(
                value: item.name,
                child: Text(item.name ?? "", style: theme.textTheme.bodySmall),
              );
            }).toList(),
          ),
          spaceDown(Dimensions.space16.h),
          LabelTextField(
            maxLines: 5,
            labelText: MyStrings.productDescription.tr,
            hintText: MyStrings.enterProductDescription.tr,
            controller: controller.productDescriptionController,
            onChanged: (value) {},
            contentPadding: EdgeInsetsDirectional.symmetric(
                vertical: Dimensions.space17.h,
                horizontal: Dimensions.space16.w),
            textInputType: TextInputType.text,
            textInputAction: TextInputAction.done,
            radius: Dimensions.largeRadius,
            validator: (value) {
              if (value!.isEmpty) {
                return MyStrings.fieldErrorMsg.tr;
              } else {
                return null;
              }
            },
          ),
          spaceDown(Dimensions.space16.h),
          controller.selectedProductType == "Variable"
              ? LabelText(
                  text: MyStrings.attribute.tr,
                  isRequired: true,
                  textStyle: theme.textTheme.labelMedium?.copyWith(
                      fontSize: Dimensions.space15.sp, color: MyColor.black),
                )
              : SizedBox(),
          controller.selectedProductType == "Variable"
              ? spaceDown(Dimensions.space5.h)
              : const SizedBox(),
          controller.selectedProductType == "Variable"
              ? CustomAppCard(
                  radius: Dimensions.space10,
                  onPressed: () {
                    CustomBottomSheet(
                      isNeedMargin: false,
                      child: const SelectedAttributeBottomSheet(),
                    ).customBottomSheet(context);
                  },
                  child: Row(
                    mainAxisSize: MainAxisSize.min,
                    children: [
                      Expanded(
                        child: Wrap(
                          spacing: Dimensions.space8,
                          runSpacing: Dimensions
                              .space8, // Vertical spacing between rows
                          children: List.generate(
                            controller.selectedUpdateAttributes.length,
                            (index) {
                              final products =
                                  controller.selectedUpdateAttributes[index];
                              return CustomAppCard(
                                  backgroundColor: MyColor.getPrimaryColor(),
                                  radius: Dimensions.space10.h,
                                  padding: EdgeInsetsDirectional.symmetric(
                                    vertical: Dimensions.space8,
                                    horizontal: Dimensions.space10,
                                  ),
                                  child: Text(products.name ?? "",
                                      style:
                                          theme.textTheme.bodySmall?.copyWith(
                                        color: MyColor.white,
                                      )));
                            },
                          ),
                        ),
                      ),
                      Icon(Icons.arrow_drop_down_rounded)
                    ],
                  ),
                )
              : const SizedBox(),
          spaceDown(Dimensions.space16.h),
          controller.selectedProductType == "Variable"
              ? LabelText(
                  text: MyStrings.variant.tr,
                  isRequired: true,
                  textStyle: theme.textTheme.labelMedium?.copyWith(
                      fontSize: Dimensions.space15.sp, color: MyColor.black),
                )
              : SizedBox(),
          const SizedBox(height: Dimensions.textToTextSpace),
          controller.selectedProductType == "Variable"
              ? CustomAppCard(
                  radius: Dimensions.space10,
                  onPressed: () {
                    CustomBottomSheet(
                      isNeedMargin: false,
                      child: const SelectedVariantBottomSheet(),
                    ).customBottomSheet(context);
                  },
                  child: Row(
                    mainAxisSize: MainAxisSize.min,
                    children: [
                      Expanded(
                        child: Wrap(
                          spacing: Dimensions.space8,
                          runSpacing: Dimensions
                              .space8, // Vertical spacing between rows
                          children: List.generate(
                            controller.selectedVariants.length,
                            (index) {
                              final products =
                                  controller.selectedVariants[index];
                              return CustomAppCard(
                                  backgroundColor: MyColor.getPrimaryColor(),
                                  radius: Dimensions.space10.h,
                                  padding: EdgeInsetsDirectional.symmetric(
                                    vertical: Dimensions.space8,
                                    horizontal: Dimensions.space10,
                                  ),
                                  child: Text(products.name ?? "",
                                      style:
                                          theme.textTheme.bodySmall?.copyWith(
                                        color: MyColor.white,
                                      )));
                            },
                          ),
                        ),
                      ),
                      Icon(Icons.arrow_drop_down_rounded)
                    ],
                  ),
                )
              : SizedBox(),
          spaceDown(Dimensions.space16.h),
          LabelText(
            text: MyStrings.productImage.tr,
            textStyle: theme.textTheme.labelMedium?.copyWith(
                fontSize: Dimensions.space15.sp, color: MyColor.black),
          ),
          spaceDown(Dimensions.space8.h),
          CustomPaint(
            painter: DottedBorderPainter(),
            child: CustomAppCard(
              onPressed: () {
                controller.pickFile();
              },
              showBorder: false,
              width: double.infinity,
              child: Stack(
                children: [
                  Align(
                    alignment: Alignment.center,
                    child: controller.selectedFile == null
                        ? Column(
                            children: [
                              MyAssetImageWidget(
                                  assetPath: MyIcons.addImage,
                                  isSvg: true,
                                  height: Dimensions.space56.h,
                                  width: Dimensions.space56.w,
                                  color: theme.primaryColor),
                              Text(
                                MyStrings.tapToAddImage.tr,
                                style: theme.textTheme.bodyLarge?.copyWith(
                                  fontSize: Dimensions.space16.sp,
                                ),
                              )
                            ],
                          )
                        : PickImageSection(
                            selectedFile: controller.selectedFile,
                          ),
                  ),
                  if (controller.selectedFile != null)
                    Align(
                      alignment: Alignment.topRight,
                      child: CustomAppCard(
                        onPressed: () {
                          controller.removeSelectedFile();
                        },
                        showBorder: false,
                        padding: EdgeInsetsDirectional.all(Dimensions.space10),
                        radius: Dimensions.space8,
                        backgroundColor:
                            MyColor.getErrorColor().withValues(alpha: .2),
                        child: MyAssetImageWidget(
                          assetPath: MyIcons.delete,
                          isSvg: true,
                          height: Dimensions.space16.h,
                          width: Dimensions.space16.w,
                        ),
                      ),
                    ),
                ],
              ),
            ),
          ),
        ],
      );
    });
  }
}
