import 'dart:ui';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/app/components/shimmer/new_purchase_shimmer.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/app/components/stepper/custom_stepper.dart';
import 'package:ovosale/app/screens/products/widgets/new_products_form_step_one.dart';
import 'package:ovosale/app/screens/products/widgets/products_details_form.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/new_product/new_product_controller.dart';
import 'package:ovosale/data/model/product/add_new_product_response_model.dart';
import 'package:ovosale/data/repo/new_product/new_product_repo.dart';

class NewProductScreen extends StatefulWidget {
  const NewProductScreen({super.key});

  @override
  State<NewProductScreen> createState() => _NewProductScreenState();
}

class _NewProductScreenState extends State<NewProductScreen> {
  @override
  void initState() {
    Get.put(NewProductRepo());
    final controller =
        Get.put(NewProductController(newProductRepo: Get.find()));

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.getAddProductData();
    });
  }

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<NewProductController>(
      builder: (controller) => MyCustomScaffold(
        padding: EdgeInsetsDirectional.zero,
        pageTitle: MyStrings.newProducts.tr,
        body: controller.loading
            ? NewPurchaseShimmer()
            : CustomAppCard(
                radius: 0,
                margin: EdgeInsetsDirectional.symmetric(
                    vertical: Dimensions.space10.h),
                showBorder: false,
                child: SingleChildScrollView(
                  child: Column(
                    children: [
                      CustomStepperWidget(
                        currentStep: controller.isStep2 ? 1 : 0,
                        onStepChanged: (index) {
                          if (index == 1 && !controller.isStep2) {
                            controller.stepChanger();
                          }
                        },
                        steps: [
                          CustomStep(
                            title: "",
                            isActive: !controller.isStep2,
                            content: NewProductsFormStepOne(),
                          ),
                          CustomStep(
                            title: "",
                            isActive: controller.isStep2,
                            content: Column(
                              children: [
                                ListView.builder(
                                  physics: NeverScrollableScrollPhysics(),
                                  itemCount:
                                      controller.selectedProductType == "Static"
                                          ? 1
                                          : controller.formData.length,
                                  shrinkWrap: true,
                                  itemBuilder: (context, index) {
                                    return Column(
                                      children: [
                                        Row(
                                          children: [
                                            Expanded(child: CustomDivider()),
                                            Padding(
                                              padding:
                                                  const EdgeInsets.symmetric(
                                                      horizontal:
                                                          Dimensions.space15),
                                              child: Text(
                                                "${controller.selectedProductType == "Static" ? "" : controller.getAttributeName(controller.formData[index].attributeId.toString())}"
                                                "${controller.selectedProductType == "Static" ? "" : "-"} ${controller.selectedProductType == "Static" ? MyStrings.productDetails.tr : controller.formData[index].variantName.toString()}",
                                                style: theme
                                                    .textTheme.headlineSmall,
                                              ),
                                            ),
                                            Expanded(child: CustomDivider()),
                                          ],
                                        ),
                                        ProductsDetailsForm(
                                          index: index,
                                        ),
                                        spaceDown(Dimensions.space20),
                                      ],
                                    );
                                  },
                                ),
                                spaceDown(Dimensions.space20),
                                Row(
                                  children: [
                                    Expanded(
                                        child: CustomElevatedBtn(
                                            bgColor: MyColor.getBodyTextColor(),
                                            text: MyStrings.previous.tr,
                                            onTap: () {
                                              controller.stepChanger();
                                            })),
                                    spaceSide(Dimensions.space10),
                                    Expanded(
                                        child: CustomElevatedBtn(
                                            isLoading: controller.submitLoading,
                                            text: MyStrings.save.tr,
                                            onTap: () {
                                              controller.submitProductData();
                                            })),
                                  ],
                                )
                              ],
                            ),
                          ),
                        ],
                      ),
                      controller.isStep2 == false
                          ? CustomElevatedBtn(
                              onTap: () {
                                if (controller.productNameController.text !=
                                    "") {
                                  if (controller.selectedBrandId != "") {
                                    if (controller.selectedUnitId != "") {
                                      if (controller.selectedCategoryId != "") {
                                        if (controller.selectedProductType ==
                                            "Static") {
                                          controller.formData
                                              .add(ProductDetailsFormModel());
                                        }

                                        controller.stepChanger();
                                      } else {
                                        CustomSnackBar.error(errorList: [
                                          MyStrings.categoryNameIsRequired.tr
                                        ]);
                                      }
                                    } else {
                                      CustomSnackBar.error(errorList: [
                                        MyStrings.unitNameIsRequired.tr
                                      ]);
                                    }
                                  } else {
                                    CustomSnackBar.error(errorList: [
                                      MyStrings.brandNameIsRequired.tr
                                    ]);
                                  }
                                } else {
                                  CustomSnackBar.error(errorList: [
                                    MyStrings.productNameIsRequired.tr
                                  ]);
                                }
                              },
                              text: MyStrings.continues.tr,
                            )
                          : const SizedBox(),
                      // Text(controller.body.toString())
                    ],
                  ),
                ),
              ),
      ),
    );
  }
}

class DottedBorderPainter extends CustomPainter {
  @override
  void paint(Canvas canvas, Size size) {
    final paint = Paint()
      ..color = MyColor.getPrimaryColor()
      ..strokeWidth = 2
      ..style = PaintingStyle.stroke;

    final double dashWidth = 3; // Width of each dash
    final double dashSpace = 2; // Space between each dash
    final double cornerRadius = 10; // Radius for rounded corners

    final path = Path()
      ..addRRect(RRect.fromRectAndRadius(
          Rect.fromLTWH(0, 0, size.width, size.height),
          Radius.circular(cornerRadius)));

    final PathMetrics pathMetrics = path.computeMetrics();

    for (PathMetric pathMetric in pathMetrics) {
      double distance = 0;
      while (distance < pathMetric.length) {
        final Tangent? tangent = pathMetric.getTangentForOffset(distance);
        if (tangent != null) {
          final Offset start = tangent.position;
          final Offset end = tangent.position +
              Offset(
                  dashWidth * tangent.vector.dx, dashWidth * tangent.vector.dy);
          canvas.drawLine(start, end, paint);
        }
        distance += dashWidth + dashSpace;
      }
    }
  }

  @override
  bool shouldRepaint(CustomPainter oldDelegate) => false;
}
