import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/product_details/product_details_controller.dart';
import 'package:ovosale/data/model/product_details/product_details_data_response_model.dart';

class ProductsDetailsTile extends StatelessWidget {
  final List<Detail> productDetails;
  final int index;
  const ProductsDetailsTile({
    super.key,
    required this.index,
    required this.productDetails,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<ProductDetailsController>(
      builder: (controller) => CustomAppCard(
          padding: EdgeInsetsDirectional.zero,
          radius: Dimensions.space10,
          showBorder: false,
          child: ExpansionTile(
            childrenPadding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space10.w,
                vertical: Dimensions.space8.h),
            tilePadding: EdgeInsetsDirectional.symmetric(
                vertical: Dimensions.space5.h,
                horizontal: Dimensions.space10.w),
            title: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(
                  productDetails[index].sku ?? "",
                  style: theme.textTheme.bodySmall
                      ?.copyWith(color: MyColor.getPrimaryColor()),
                ),
                Text(
                  "${AppConverter.formatNumber(productDetails[index].basePrice ?? "")} ${controller.defaultCurrency}",
                  overflow: TextOverflow.ellipsis,
                  style: theme.textTheme.headlineSmall
                      ?.copyWith(fontSize: Dimensions.space16.sp),
                ),
                Row(
                  children: [
                    Text(
                      "${MyStrings.purchasePrice.tr}:",
                      style: theme.textTheme.bodySmall?.copyWith(
                          fontWeight: FontWeight.w600,
                          fontSize: Dimensions.space12.sp),
                    ),
                    Text(
                      "${AppConverter.formatNumber(productDetails[index].purchasePrice ?? "")} ${controller.defaultCurrency}",
                      style: theme.textTheme.bodySmall
                          ?.copyWith(fontSize: Dimensions.space12.sp),
                    ),
                    Container(
                      margin: EdgeInsetsDirectional.symmetric(
                          horizontal: Dimensions.space4),
                      height: Dimensions.space10.h,
                      width: Dimensions.space2.w,
                      color: MyColor.getBodyTextColor(),
                    ),
                    Expanded(
                      child: Text(
                        "${MyStrings.salePrice.tr}:",
                        style: theme.textTheme.bodySmall?.copyWith(
                            fontWeight: FontWeight.w600,
                            fontSize: Dimensions.space12.sp),
                      ),
                    ),
                    Expanded(
                      child: Text(
                        "${AppConverter.formatNumber(productDetails[index].salePrice ?? "")} ${controller.defaultCurrency}",
                        style: theme.textTheme.bodySmall
                            ?.copyWith(fontSize: Dimensions.space12.sp),
                      ),
                    ),
                  ],
                ),
                Row(
                  children: [
                    Text(
                      "${MyStrings.finalPrice.tr}:",
                      style: theme.textTheme.bodySmall?.copyWith(
                          fontWeight: FontWeight.w600,
                          fontSize: Dimensions.space12.sp),
                    ),
                    Text(
                      "${AppConverter.formatNumber(productDetails[index].finalPrice ?? "")} ${controller.defaultCurrency}",
                      style: theme.textTheme.bodySmall
                          ?.copyWith(fontSize: Dimensions.space12.sp),
                    ),
                  ],
                )
              ],
            ),
            children: [
              if (controller.products?.productType.toString() == "2") ...[
                Row(
                  children: [
                    Text(
                      "${MyStrings.attribute.tr} : ",
                      style: theme.textTheme.bodySmall?.copyWith(
                          fontWeight: FontWeight.w600,
                          fontSize: Dimensions.space12.sp),
                    ),
                    Text(
                      " ${AppConverter.formatNumber(productDetails[index].attribute?.name ?? "")}",
                      style: theme.textTheme.bodySmall?.copyWith(
                          fontWeight: FontWeight.w400,
                          fontSize: Dimensions.space12.sp),
                    ),
                    Container(
                      margin: EdgeInsetsDirectional.symmetric(
                          horizontal: Dimensions.space4),
                      height: Dimensions.space10.h,
                      width: Dimensions.space2.w,
                      color: MyColor.getBodyTextColor(),
                    ),
                    Text(
                      "${MyStrings.variant.tr} : ",
                      style: theme.textTheme.bodySmall?.copyWith(
                          fontWeight: FontWeight.w600,
                          fontSize: Dimensions.space12.sp),
                    ),
                    Text(
                      " ${AppConverter.formatNumber(productDetails[index].variant?.name ?? "")}",
                      style: theme.textTheme.bodySmall?.copyWith(
                          fontWeight: FontWeight.w400,
                          fontSize: Dimensions.space12.sp),
                    ),
                  ],
                ),
                spaceDown(Dimensions.space4.h),
              ],
              Row(
                children: [
                  Text(
                    "${MyStrings.tax.tr} : ",
                    style: theme.textTheme.bodySmall?.copyWith(
                        fontWeight: FontWeight.w600,
                        fontSize: Dimensions.space12.sp),
                  ),
                  Text(
                    "${productDetails[index].taxType == "2" ? MyStrings.inclusive : MyStrings.exclusive} ${AppConverter.formatNumber(productDetails[index].taxPercentage ?? "")}",
                    style: theme.textTheme.bodySmall?.copyWith(
                        fontWeight: FontWeight.w400,
                        fontSize: Dimensions.space12.sp),
                  ),
                ],
              ),
              spaceDown(Dimensions.space4.h),
              Row(
                children: [
                  Text(
                    "${MyStrings.taxAmount.tr} : ",
                    style: theme.textTheme.bodySmall?.copyWith(
                        fontWeight: FontWeight.w600,
                        fontSize: Dimensions.space12.sp),
                  ),
                  Text(
                    "${AppConverter.formatNumber(productDetails[index].taxAmount ?? "")} ${controller.defaultCurrency}",
                    style: theme.textTheme.bodySmall?.copyWith(
                        fontWeight: FontWeight.w400,
                        fontSize: Dimensions.space12.sp),
                  ),
                ],
              ),
              spaceDown(Dimensions.space4.h),
              Row(
                children: [
                  Text(
                    "${MyStrings.profitMargin.tr} : ",
                    style: theme.textTheme.bodySmall?.copyWith(
                        fontWeight: FontWeight.w600,
                        fontSize: Dimensions.space12.sp),
                  ),
                  Text(
                    "${AppConverter.formatNumber(productDetails[index].profitMargin ?? "")} ${controller.defaultCurrency}",
                    style: theme.textTheme.bodySmall?.copyWith(
                        fontWeight: FontWeight.w400,
                        fontSize: Dimensions.space12.sp),
                  ),
                ],
              ),
              spaceDown(Dimensions.space4.h),
              Row(
                children: [
                  Text(
                    "${MyStrings.discount.tr} : ",
                    style: theme.textTheme.bodySmall?.copyWith(
                        fontWeight: FontWeight.w600,
                        fontSize: Dimensions.space12.sp),
                  ),
                  Text(
                    "${AppConverter.formatNumber(productDetails[index].discountAmount ?? "")} ${controller.defaultCurrency}",
                    style: theme.textTheme.bodySmall?.copyWith(
                        fontWeight: FontWeight.w400,
                        fontSize: Dimensions.space12.sp),
                  ),
                ],
              ),
              spaceDown(6.h),
            ],
          )),
    );
  }
}
