import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/screens/product_details/widgets/product_details_tile.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/product_details/product_details_controller.dart';

class ProductDetailsSection extends StatelessWidget {
  const ProductDetailsSection({super.key});

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<ProductDetailsController>(
      builder: (controller) => Column(
        children: [
          CustomAppCard(
            padding: EdgeInsetsDirectional.all(Dimensions.space16),
            showBorder: false,
            radius: Dimensions.space20,
            width: double.infinity,
            child: Row(
              children: [
                Expanded(
                  child: Column(
                    mainAxisSize: MainAxisSize.min,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(
                        MyStrings.productType.tr,
                        style: theme.textTheme.bodySmall,
                      ),
                      Text(
                          controller.products?.productType.toString() == "1"
                              ? MyStrings.statics.tr
                              : MyStrings.variable.tr,
                          style: theme.textTheme.headlineSmall),
                      spaceDown(Dimensions.space16),
                      Text(
                        MyStrings.brand.tr,
                        style: theme.textTheme.bodySmall,
                      ),
                      Text(controller.products?.brand?.name ?? "",
                          style: theme.textTheme.headlineSmall),
                      spaceDown(Dimensions.space16),
                      Text(
                        MyStrings.unit.tr,
                        style: theme.textTheme.bodySmall,
                      ),
                      Text(controller.products?.unit?.name.toString() ?? "",
                          style: theme.textTheme.headlineSmall),
                      spaceDown(Dimensions.space16),
                    ],
                  ),
                ),
                spaceSide(Dimensions.space10),
                Expanded(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(
                        MyStrings.productCode.tr,
                        style: theme.textTheme.bodySmall,
                      ),
                      Text(controller.products?.productCode.toString() ?? "",
                          style: theme.textTheme.headlineSmall),
                      spaceDown(Dimensions.space16),
                      Text(
                        MyStrings.categories.tr,
                        style: theme.textTheme.bodySmall,
                      ),
                      Text(controller.products?.category?.name.toString() ?? "",
                          style: theme.textTheme.headlineSmall),
                      spaceDown(Dimensions.space16),
                      Text(
                        MyStrings.description.tr,
                        style: theme.textTheme.bodySmall,
                      ),
                      Text(
                          controller.products?.description.toString() != "null"
                              ? controller.products?.description.toString() ??
                                  ""
                              : MyStrings.na.tr,
                          style: theme.textTheme.headlineSmall),
                      spaceDown(Dimensions.space16),
                    ],
                  ),
                )
              ],
            ),
          ),
          ListView.separated(
              separatorBuilder: (context, index) =>
                  spaceDown(Dimensions.space10),
              physics: const NeverScrollableScrollPhysics(),
              padding: EdgeInsetsDirectional.all(Dimensions.space16),
              shrinkWrap: true,
              itemCount: controller.productDetails.length,
              itemBuilder: ((context, i) {
                return Column(
                  children: [
                    ProductsDetailsTile(
                      index: i,
                      productDetails: controller.productDetails,
                    )
                  ],
                );
              }))
        ],
      ),
    );
  }
}
