import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/image/my_network_image_widget.dart';
import 'package:ovosale/app/components/shimmer/product_details_shimmer.dart';
import 'package:ovosale/app/screens/product_details/widgets/product_details_section.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/product_details/product_details_controller.dart';
import 'package:ovosale/data/repo/product_details/product_details_repo.dart';

class ProductDetailsScreen extends StatefulWidget {
  const ProductDetailsScreen({super.key});

  @override
  State<ProductDetailsScreen> createState() => _ProductDetailsScreenState();
}

class _ProductDetailsScreenState extends State<ProductDetailsScreen> {
  @override
  void initState() {
    Get.put(ProductDetailsRepo());
    final controller =
        Get.put(ProductDetailsController(productDetailsRepo: Get.find()));

    super.initState();
    controller.productId = Get.arguments[0];
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.getProductDetailsData();
    });
  }

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<ProductDetailsController>(
        builder: (controller) => MyCustomScaffold(
              padding: EdgeInsets.zero,
              pageTitle: MyStrings.productDetails.tr,
              body: controller.isLoading
                  ? ProductDetailsShimmer()
                  : SingleChildScrollView(
                      child: Column(
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          spaceDown(Dimensions.space12),
                          CustomAppCard(
                              showBorder: false,
                              borderRadius: BorderRadius.only(
                                  bottomLeft:
                                      Radius.circular(Dimensions.space20),
                                  bottomRight:
                                      Radius.circular(Dimensions.space20)),
                              width: double.infinity,
                              child: Column(
                                children: [
                                  MyNetworkImageWidget(
                                      imageUrl: controller.products?.imageSrc
                                              .toString() ??
                                          "",
                                      height:
                                          MediaQuery.of(context).size.height *
                                              .3,
                                      boxFit: BoxFit.contain,
                                      width: double.infinity),
                                  Padding(
                                    padding: EdgeInsetsDirectional.symmetric(
                                        horizontal: Dimensions.space50.w,
                                        vertical: Dimensions.space12.h),
                                    child: Text(
                                      controller.products?.name ?? "",
                                      style: theme.textTheme.headlineSmall,
                                      textAlign: TextAlign.center,
                                    ),
                                  )
                                ],
                              )),
                          spaceDown(Dimensions.space12),
                          ProductDetailsSection(),
                          spaceDown(Dimensions.space12),
                        ],
                      ),
                    ),
            ));
  }
}
