import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/advance_switch/custom_switch.dart';
import 'package:ovosale/app/components/alert-dialog/custom_alert_dialog.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/app/screens/payment_methods/widgets/payment_methods_update_popup.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/payment_method/payment_method_controller.dart';

import '../../../../core/app_permission/app_permission.dart';
import '../../../../data/controller/cart/global_controller.dart';

class PaymentMethodListTile extends StatelessWidget {
  final int index;
  const PaymentMethodListTile({
    super.key,
    required this.index,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<PaymentMethodController>(
      builder: (controller) => ListTile(
        contentPadding: EdgeInsetsDirectional.zero,
        title: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Text(
              controller.filteredPaymentMethodData[index].name ?? "",
              style: theme.textTheme.titleSmall,
            ),
          ],
        ),
        trailing: Row(
          mainAxisSize: MainAxisSize.min,
          children: [
            CustomSwitch(
              isLoading: controller.paymentMethodUpdateLoadingIndex ==
                  controller.filteredPaymentMethodData[index].id,
              value: controller.filteredPaymentMethodData[index].status == "1"
                  ? true
                  : false,
              onChanged: (v) {
                if (controller.filteredPaymentMethodData[index].isDefault
                        .toString() ==
                    "0") {
                  controller.changeStatus(
                      controller.filteredPaymentMethodData[index].id.toString(),
                      index,
                      v);
                } else {
                  CustomSnackBar.error(errorList: [
                    MyStrings.defaultGatewayStatusCantBeChanged.tr
                  ]);
                }
              },
            ),
            spaceSide(Dimensions.space10),
            controller.filteredPaymentMethodData[index].isDefault == "0"
                ? CustomAppCard(
                    onPressed: () {
                      if (Get.find<GlobalController>().checkPermission(
                          featureName: AppPermissions.editPaymentType)) {
                        controller.selectedMethodId = controller
                            .filteredPaymentMethodData[index].id
                            .toString();
                        CustomAlertDialog(
                            child: PaymentMethodsUpdatePopup(
                          name: controller.filteredPaymentMethodData[index].name
                              .toString(),
                        )).customAlertDialog(context);
                      }
                    },
                    showBorder: false,
                    padding: EdgeInsetsDirectional.all(8),
                    radius: Dimensions.space8,
                    height: Dimensions.space32.h,
                    width: Dimensions.space32.w,
                    backgroundColor:
                        MyColor.getInformationColor().withValues(alpha: .2),
                    child: MyAssetImageWidget(
                      assetPath: MyIcons.edit,
                      isSvg: true,
                      height: Dimensions.space10.h,
                      width: Dimensions.space16.w,
                    ))
                : SizedBox(),
          ],
        ),
      ),
    );
  }
}
