import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/payment_method/new_payment_method_controller.dart';
import 'package:ovosale/data/repo/payment_method/new_payment_method_repo.dart';

class NewPaymentmethodScreen extends StatefulWidget {
  const NewPaymentmethodScreen({super.key});

  @override
  State<NewPaymentmethodScreen> createState() => _NewPaymentmethodScreenState();
}

class _NewPaymentmethodScreenState extends State<NewPaymentmethodScreen> {
  @override
  void initState() {
    Get.put(NewPaymentmethodRepo());
    Get.put(NewPaymentmethodController(newPaymentMethodRepo: Get.find()));

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {});
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<NewPaymentmethodController>(
      builder: (controller) => MyCustomScaffold(
        padding: EdgeInsetsDirectional.zero,
        pageTitle: MyStrings.newPaymentMethod.tr,
        body: SingleChildScrollView(
          child: CustomAppCard(
              radius: 0,
              margin: EdgeInsetsDirectional.symmetric(
                  vertical: Dimensions.space10.h),
              showBorder: false,
              child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    LabelTextField(
                      labelText: MyStrings.methodName.tr,
                      controller: controller.methodNameController,
                      isRequired: true,
                      onChanged: (value) {},
                      contentPadding: EdgeInsetsDirectional.symmetric(
                          vertical: Dimensions.space17.h,
                          horizontal: Dimensions.space16.w),
                      textInputType: TextInputType.text,
                      textInputAction: TextInputAction.done,
                      radius: Dimensions.largeRadius,
                      validator: (value) {
                        if (value!.isEmpty) {
                          return MyStrings.fieldErrorMsg.tr;
                        } else {
                          return null;
                        }
                      },
                    ),
                    spaceDown(Dimensions.space16.h),
                    CustomElevatedBtn(
                      isLoading: controller.submitLoading,
                      text: MyStrings.save.tr,
                      onTap: () {
                        if (controller.methodNameController.text != "") {
                          controller.submitMethodData();
                        } else {
                          CustomSnackBar.error(
                              errorList: [MyStrings.filltheRequieredField.tr]);
                        }
                      },
                      height: Dimensions.space56.h,
                      radius: Dimensions.largeRadius,
                    ),
                  ])),
        ),
      ),
    );
  }
}
