import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/text-field/custom_drop_down_text_field.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/payment/payment_controller.dart';

class PaymentOptionSection extends StatelessWidget {
  const PaymentOptionSection({super.key});

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<PaymentController>(
      builder: (controller) => Column(
        children: [
          spaceDown(Dimensions.space12),
          CustomAppCard(
              width: double.infinity,
              showBorder: false,
              radius: Dimensions.space12,
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Text(
                    MyStrings.paymentMethod.tr,
                    style: theme.textTheme.labelSmall?.copyWith(
                        fontWeight: FontWeight.w600, color: MyColor.black),
                  ),
                  Column(
                    children: List.generate(controller.paymentMethodList.length,
                        (index) {
                      return CustomAppCard(
                        onPressed: () {
                          controller.changeSelectedPaymentMethod(index);
                        },
                        margin: EdgeInsets.only(top: 12.h),
                        radius: Dimensions.space12,
                        width: double.infinity,
                        padding: EdgeInsetsDirectional.all(Dimensions.space4),
                        backgroundColor: theme.cardColor,
                        borderColor:
                            controller.paymentMethodCurrentIndex == index
                                ? theme.primaryColor
                                : MyColor.getBorderColor(),
                        child: Row(
                          children: [
                            CustomAppCard(
                                radius: Dimensions.space8,
                                backgroundColor:
                                    MyColor.getSectionBackgroundColor(),
                                padding: EdgeInsetsDirectional.all(
                                    Dimensions.space12.h),
                                showBorder: false,
                                child: MyAssetImageWidget(
                                  assetPath: controller
                                              .paymentMethodList[index].name ==
                                          "Card"
                                      ? MyIcons.cardPayment
                                      : MyIcons.cashPayment,
                                  isSvg: true,
                                  height: Dimensions.space24.h,
                                  width: Dimensions.space24.w,
                                )),
                            spaceSide(Dimensions.space8),
                            Expanded(
                                child: Text(
                                    controller.paymentMethodList[index].name ??
                                        "",
                                    style: theme.textTheme.bodyLarge
                                        ?.copyWith(color: MyColor.black))),
                          ],
                        ),
                      );
                    }),
                  ),
                ],
              )),
          if (controller.paymentAccountsDataList.isNotEmpty) ...[
            spaceDown(Dimensions.space12),
            CustomDropDownTextField(
              selectedValue: controller.paymentAccountsDataList.isNotEmpty
                  ? controller.paymentAccountsDataList.first
                  : null,
              onChanged: (value) {
                controller.setSelectedPaymentAccount(value);
              },
              labelText: MyStrings.paymentAccount.tr,
              items: controller.paymentAccountsDataList.map((item) {
                return DropdownMenuItem(
                  value: item,
                  child: Text(
                    item.accountName ?? "",
                    style: theme.textTheme.bodySmall,
                  ),
                );
              }).toList(),
            ),
          ],
        ],
      ),
    );
  }
}
