import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/data/controller/cart/global_controller.dart';
import 'package:ovosale/data/controller/new_sale/new_sale_controller.dart';
import '../../../../core/utils/my_color.dart';
import '../../../../core/utils/my_strings.dart';
import '../../../../core/utils/style.dart';
import '../../../components/bottom-sheet/bottom_sheet_bar.dart';
import '../../../components/custom_loader/custom_loader.dart';
import '../../../components/divider/custom_divider.dart';

class WarehouseSection extends StatefulWidget {
  const WarehouseSection({
    super.key,
  });

  @override
  State<WarehouseSection> createState() => _WarehouseSectionState();
}

class _WarehouseSectionState extends State<WarehouseSection> {
  final ScrollController scrollController = ScrollController();
  void scrollListener() {
    if (scrollController.position.pixels == scrollController.position.maxScrollExtent) {
      if (Get.find<GlobalController>().hasNext()) {
        Get.find<GlobalController>().loadWareHouseData(isPagination: true);
      }
    }
  }

  @override
  void initState() {
    super.initState();
    scrollController.addListener(scrollListener);
  }

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);

    return GetBuilder<NewSaleController>(
      builder: (controller) => GetBuilder<GlobalController>(
        builder: (cartCountController) => Padding(
          padding: const EdgeInsets.symmetric(horizontal: 14),
          child: Column(
            mainAxisSize: MainAxisSize.min,
            children: [
              Column(
                children: [
                  BottomSheetBar(),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Text(
                        MyStrings.warehouse.tr,
                        style: boldLarge.copyWith(fontSize: 18, fontWeight: FontWeight.w700),
                      ),
                      IconButton(
                          onPressed: () {
                            Get.back();
                          },
                          icon: Icon(Icons.close))
                    ],
                  ),
                  SizedBox(
                    height: context.height * .03,
                  )
                ],
              ),
              Flexible(
                child: ListView.builder(
                  itemCount: cartCountController.wareHouseList.length + 1,
                  controller: scrollController,
                  shrinkWrap: true,
                  itemBuilder: (context, index) {
                    if (cartCountController.wareHouseList.length == index) {
                      return cartCountController.hasNext() ? const CustomLoader(isPagination: true) : const SizedBox();
                    }

                    return GestureDetector(
                      onTap: () {
                        controller.changeSelectedWareHouse(cartCountController.wareHouseList[index]);
                      },
                      child: Container(
                        // color: cartCountController.selectedWareHouse.id == cartCountController.wareHouseList[index].id ? theme.primaryColor : theme.scaffoldBackgroundColor,
                        color: MyColor.white,
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            SizedBox(
                              width: context.width,
                              child: Row(
                                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                children: [Text(cartCountController.wareHouseList[index].name ?? "", style: theme.textTheme.titleSmall), cartCountController.selectedWareHouse.id == cartCountController.wareHouseList[index].id ? Icon(Icons.check, color: theme.primaryColor) : SizedBox.shrink()],
                              ),
                            ),
                            CustomDivider(
                              color: Colors.black,
                            )
                          ],
                        ),
                      ),
                    );
                  },
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
