import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_network_image_widget.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/new_sale/new_sale_controller.dart';

class CategorySection extends StatelessWidget {
  const CategorySection({super.key});

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<NewSaleController>(
      builder: (controller) => CustomAppCard(
        onPressed: () {},
        width: double.infinity,
        padding: EdgeInsetsDirectional.only(
            top: Dimensions.space5.h, bottom: Dimensions.space5.h),
        backgroundColor: theme.colorScheme.secondary.withValues(alpha: 0.10),
        // backgroundColor: theme.scaffoldBackgroundColor,
        radius: 0,
        child: SingleChildScrollView(
          scrollDirection: Axis.horizontal,
          child: IntrinsicHeight(
            child: Row(
              children: List.generate(controller.categoryList.length, (index) {
                var category = controller.categoryList[index];

                return CustomAppCard(
                  margin: EdgeInsets.only(right: 8),
                  borderColor: theme.primaryColor,
                  showBorder: false,
                  onPressed: () {},

                  padding: EdgeInsetsDirectional.symmetric(
                      horizontal: Dimensions.space4,
                      vertical: Dimensions.space8),
                  // margin: EdgeInsetsDirectional.only(start: Dimensions.space2, end: Dimensions.space2),
                  backgroundColor: category.isSelected
                      ? theme.primaryColor.withValues(alpha: 1)
                      : MyColor.transparent,

                  radius: 10,
                  child: Column(
                    children: [
                      CustomAppCard(
                        onPressed: () {
                          controller.onCategorySelect(category);
                        },
                        height: Dimensions.space60.h,
                        width: Dimensions.space60.w,
                        padding: EdgeInsetsDirectional.all(Dimensions.space3),
                        backgroundColor: MyColor.white,
                        showBorder: true,
                        radius: 10,
                        child: MyNetworkImageWidget(
                          imageUrl: category.imageSrc ?? "",
                          height: Dimensions.space40.h,
                          width: Dimensions.space40.w,
                          boxFit: BoxFit.contain,
                        ),
                      ),
                      spaceDown(Dimensions.space4),
                      SizedBox(
                        width: 52.w,
                        child: Text(
                          category.name ?? "",
                          textAlign: TextAlign.center,
                          overflow: TextOverflow.ellipsis,
                          maxLines: 1,
                          style: theme.textTheme.headlineSmall?.copyWith(
                              fontSize: Dimensions.space12.sp,
                              color: category.isSelected
                                  ? MyColor.white
                                  : MyColor.getHeadingTextColor()),
                        ),
                      ),
                    ],
                  ),
                );
              }),
            ),
          ),
        ),
      ),
    );
  }
}
