import 'dart:async';

import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/new_sale/new_sale_controller.dart';

class AppBarSection extends StatefulWidget {
  const AppBarSection({super.key});

  @override
  State<AppBarSection> createState() => _AppBarSectionState();
}

class _AppBarSectionState extends State<AppBarSection> {
  Timer? _debounceTimer;

  @override
  void dispose() {
    _debounceTimer?.cancel(); // Cancel the timer when the widget is disposed
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<NewSaleController>(
      builder: (controller) => Container(
        padding: EdgeInsetsDirectional.symmetric(
            horizontal: Dimensions.space16.w, vertical: Dimensions.space12.h),
        color: MyColor.white,
        child: Row(
          children: [
            Expanded(
              child: LabelTextField(
                  controller: controller.filterSearchController,
                  contentPadding: EdgeInsetsDirectional.symmetric(
                      vertical: Dimensions.space14.h,
                      horizontal: Dimensions.space16.w),
                  labelText: "",
                  hideLabel: true,
                  hintText: MyStrings.searchProduct.tr,
                  hintTextColor: MyColor.getBodyTextColor(),
                  onChanged: (value) {
                    if (_debounceTimer?.isActive ?? false) {
                      _debounceTimer?.cancel();
                    }

                    // Start a new timer
                    _debounceTimer =
                        Timer(const Duration(milliseconds: 500), () {
                      controller.onSearch();
                    });
                  },
                  textInputType: TextInputType.text,
                  textInputAction: TextInputAction.done,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                  prefixIcon: Icon(
                    CupertinoIcons.search,
                    size: Dimensions.textFieldIconSize,
                  ),
                  suffixIcon:
                      controller.filterSearchController.text.trim().isNotEmpty
                          ? IconButton(
                              onPressed: () {
                                controller.onClearTextField();
                              },
                              icon: Icon(
                                Icons.close,
                                size: 20,
                                color: MyColor.getBodyTextColor(),
                              ))
                          : null),
            ),
          ],
        ),
      ),
    );
  }
}
