import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/auto_grid_view/auto_height_grid_view.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_network_image_widget.dart';
import 'package:ovosale/app/components/no_data.dart';
import 'package:ovosale/app/components/shimmer/new_sale_shimmer.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/new_sale/new_sale_controller.dart';

import '../../../../data/services/shared_pref_service.dart';

class AllProductsSection extends StatelessWidget {
  const AllProductsSection({
    super.key,
    required this.historyScrollController,
  });
  final ScrollController historyScrollController;
  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    ThemeData theme = Theme.of(context);
    return GetBuilder<NewSaleController>(
      builder: (controller) => controller.isProductLoading
          ? Column(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                NewSaleShimmer(
                  hideTopShimmer: true,
                )
              ],
            )
          : controller.saleProductList.isEmpty
              ? SizedBox(height: size.height / 2.5, child: NoDataWidget())
              : AutoHeightGridView(
                  physics: NeverScrollableScrollPhysics(),
                  itemCount: controller.saleProductList.length,
                  crossAxisCount: size.width > 500 ? 4 : 4,
                  mainAxisSpacing: Dimensions.space8,
                  crossAxisSpacing: 0,
                  padding: const EdgeInsets.symmetric(horizontal: 8),
                  shrinkWrap: true,
                  // controller: historyScrollController,
                  builder: (context, index) {
                    var product = controller.saleProductList[index];

                    return GestureDetector(
                      onTap: () async {
                        product.isLoading = true;
                        controller.update();
                        await controller.globalCartCountController
                            .addToCart(product)
                            .then((value) {
                          product.isLoading = false;
                          controller.update();
                        });
                      },
                      child: Padding(
                        padding: const EdgeInsets.symmetric(
                            horizontal: 4, vertical: 6),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Stack(
                              children: [
                                CustomAppCard(
                                  height: Dimensions.space70.h,
                                  width: Dimensions.space70.w,
                                  padding: EdgeInsetsDirectional.all(
                                      Dimensions.space5),
                                  backgroundColor: MyColor.white,
                                  showBorder: true,
                                  radius: 10,
                                  child: MyNetworkImageWidget(
                                    imageUrl: product.imageSrc ?? '',
                                    height: Dimensions.space60.h,
                                    width: Dimensions.space60.w,
                                    boxFit: BoxFit.cover,
                                  ),
                                ),
                                PositionedDirectional(
                                  bottom: 2.5,
                                  end: 2.5,
                                  child: product.isLoading
                                      ? SizedBox(
                                          height: Dimensions.space20,
                                          width: Dimensions.space20,
                                          child: CircularProgressIndicator(
                                            color: MyColor.getPrimaryColor(),
                                            strokeWidth: 2.5,
                                          ))
                                      : SizedBox(),
                                ),
                              ],
                            ),
                            spaceDown(Dimensions.space4),
                            Text(
                              product.name ?? "",
                              maxLines: 1,
                              overflow: TextOverflow.ellipsis,
                              style: theme.textTheme.bodySmall?.copyWith(
                                fontSize: Dimensions.space12.sp,
                              ),
                            ),
                            spaceDown(Dimensions.space4.h),
                            Text(
                              "${SharedPreferenceService.getCurrencySymbol()}${AppConverter.formatNumber(product.price ?? "")}",
                              textAlign: TextAlign.start,
                              style: theme.textTheme.headlineSmall?.copyWith(
                                  fontSize: Dimensions.space12.sp,
                                  color: theme.primaryColor),
                            ),
                            Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                spaceDown(Dimensions.space4.h),
                                Text(
                                    "${MyStrings.sku.tr}: ${product.sku ?? ""}",
                                    style: theme.textTheme.headlineSmall
                                        ?.copyWith(
                                            fontSize: Dimensions.space10.sp)),
                                spaceDown(Dimensions.space4.h),
                                if (product.inStock == "0") ...[
                                  Text(MyStrings.outOfStock.tr,
                                      style: theme.textTheme.headlineSmall
                                          ?.copyWith(
                                              fontSize: Dimensions.space10.sp,
                                              color: MyColor.lightError)),
                                ] else ...[
                                  Text(
                                      "${MyStrings.inStock.tr}: ${product.inStock ?? ""}",
                                      style: theme.textTheme.headlineSmall
                                          ?.copyWith(
                                              fontSize: Dimensions.space10.sp)),
                                ],
                                spaceDown(Dimensions.space4.h),
                                Text(
                                    "${product.attributeName}${product.attributeName!.isNotEmpty ? ":" : ""} ${product.variantName}",
                                    style: theme.textTheme.headlineSmall
                                        ?.copyWith(
                                            fontSize: Dimensions.space10.sp))
                              ],
                            )
                          ],
                        ),
                      ),
                    );
                  }),
    );
  }
}
