import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/expense_category/expense_category_controller.dart';

class UpdateExpenseCategoryPopup extends StatefulWidget {
  final String name;
  const UpdateExpenseCategoryPopup({
    super.key,
    required this.name,
  });

  @override
  State<UpdateExpenseCategoryPopup> createState() =>
      _UpdateExpenseCategoryPopupState();
}

class _UpdateExpenseCategoryPopupState
    extends State<UpdateExpenseCategoryPopup> {
  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<ExpenseCategoryController>(builder: (controller) {
      controller.expenseCategoryNameController.text = widget.name.toString();
      return Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: Row(
              children: [
                Expanded(
                    child: Text(MyStrings.updateExpenseCategory.tr.toString(),
                        style: theme.textTheme.headlineSmall)),
                GestureDetector(
                  onTap: () {
                    Get.back();
                  },
                  child: MyAssetImageWidget(
                    assetPath: MyIcons.popUpCancel,
                    height: Dimensions.space45.h,
                    width: Dimensions.space45.w,
                    isSvg: true,
                  ),
                )
              ],
            ),
          ),
          CustomDivider(),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              isRequired: true,
              onChanged: () {},
              controller: controller.expenseCategoryNameController,
              labelText: MyStrings.expenseName.tr,
              textInputType: TextInputType.phone,
              onTap: () {},
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          spaceDown(Dimensions.space16.h),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: Column(
              children: [
                spaceDown(Dimensions.space48.h),
                CustomElevatedBtn(
                  isLoading: controller.isSubmitting,
                  text: MyStrings.update.tr,
                  onTap: () {
                    controller.updateExpense();
                  },
                  height: Dimensions.space56.h,
                  radius: Dimensions.largeRadius,
                ),
              ],
            ),
          ),
        ],
      );
    });
  }
}
