import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/advance_switch/custom_switch.dart';
import 'package:ovosale/app/components/alert-dialog/custom_alert_dialog.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/screens/expense_category/widgets/update_expense_category_pop_up.dart';
import 'package:ovosale/core/helper/date_converter.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/expense_category/expense_category_controller.dart';

import '../../../../core/app_permission/app_permission.dart';

class ExpenseCategoryListTile extends StatelessWidget {
  final int index;
  const ExpenseCategoryListTile({
    super.key,
    required this.index,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<ExpenseCategoryController>(
      builder: (controller) => ListTile(
          contentPadding: EdgeInsetsDirectional.zero,
          title: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              controller.filteredExpenseCategoryData[index].name.toString() !=
                      "null"
                  ? Text(
                      "${controller.filteredExpenseCategoryData[index].name.toString()}  ",
                      style: theme.textTheme.headlineSmall?.copyWith(
                        fontWeight: FontWeight.w600,
                      ))
                  : const SizedBox(),
              controller.filteredExpenseCategoryData[index].createdAt
                          .toString() !=
                      "null"
                  ? Text(
                      DateConverter.convertIsoToString(controller
                          .filteredExpenseCategoryData[index].createdAt
                          .toString()),
                      style: theme.textTheme.bodySmall,
                    )
                  : SizedBox(),
            ],
          ),
          trailing: Row(mainAxisSize: MainAxisSize.min, children: [
            CustomSwitch(
              isLoading: controller.expenseCategoryUpdateLoadingIndex ==
                  controller.filteredExpenseCategoryData[index].id,
              value: controller.filteredExpenseCategoryData[index].status == "1"
                  ? true
                  : false,
              onChanged: (v) {
                controller.changeStatus(
                    controller.filteredExpenseCategoryData[index].id.toString(),
                    index,
                    v);
              },
            ),
            spaceSide(Dimensions.space12),
            CustomAppCard(
              onPressed: () {
                if (controller.globalController.checkPermission(
                    featureName: AppPermissions.editExpenseCategory)) {
                  controller.selectedExpenseId = controller
                      .filteredExpenseCategoryData[index].id
                      .toString();
                  CustomAlertDialog(
                    child: UpdateExpenseCategoryPopup(
                      name: controller.filteredExpenseCategoryData[index].name
                          .toString(),
                    ),
                  ).customAlertDialog(context);
                }
              },
              showBorder: false,
              padding: EdgeInsetsDirectional.all(Dimensions.space8),
              radius: Dimensions.space8,
              height: Dimensions.space32.h,
              width: Dimensions.space32.w,
              backgroundColor:
                  MyColor.getInformationColor().withValues(alpha: .2),
              child: MyAssetImageWidget(
                assetPath: MyIcons.edit,
                isSvg: true,
                height: Dimensions.space10.h,
                width: Dimensions.space16.w,
              ),
            ),
          ])),
    );
  }
}
