import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/expense_category/expense_category_controller.dart';
import 'package:ovosale/data/repo/expense_category/expense_category_repo.dart';

class NewExpenseCategoryScreen extends StatefulWidget {
  const NewExpenseCategoryScreen({super.key});

  @override
  State<NewExpenseCategoryScreen> createState() =>
      _NewExpenseCategoryScreenState();
}

class _NewExpenseCategoryScreenState extends State<NewExpenseCategoryScreen> {
  @override
  void initState() {
    Get.put(ExpenseCategoryRepo());
    Get.put(ExpenseCategoryController(expenseCategoryRepo: Get.find()));
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {});
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<ExpenseCategoryController>(
      builder: (controller) => MyCustomScaffold(
        padding: EdgeInsetsDirectional.zero,
        pageTitle: MyStrings.newExpenseCategory.tr,
        body: SingleChildScrollView(
          child: CustomAppCard(
              radius: 0,
              margin: EdgeInsetsDirectional.symmetric(
                  vertical: Dimensions.space10.h),
              showBorder: false,
              child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    LabelTextField(
                      isRequired: true,
                      onChanged: () {},
                      controller: controller.newExpenseCategoryNameController,
                      labelText: MyStrings.expenseName.tr,
                      textInputType: TextInputType.phone,
                      onTap: () {},
                      textInputAction: TextInputAction.next,
                      radius: Dimensions.largeRadius,
                      validator: (value) {
                        if (value!.isEmpty) {
                          return MyStrings.fieldErrorMsg.tr;
                        } else {
                          return null;
                        }
                      },
                    ),
                    spaceDown(Dimensions.space25.h),
                    CustomElevatedBtn(
                      isLoading: controller.isSubmitting,
                      text: MyStrings.save.tr,
                      onTap: () {
                        if (controller.expenseCategoryNameController.text !=
                            "") {
                          controller.createExpenseCategory();
                        } else {
                          CustomSnackBar.error(
                              errorList: [MyStrings.expenseNameisRequired.tr]);
                        }
                      },
                      height: Dimensions.space56.h,
                      radius: Dimensions.largeRadius,
                    ),
                  ])),
        ),
      ),
    );
  }
}
