import 'dart:async';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/custom_loader/custom_loader.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/no_data.dart';
import 'package:ovosale/app/components/shimmer/customer_database_Shimmer.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/app/screens/expense_category/widgets/expense_category_list_tile.dart';
import 'package:ovosale/core/route/route.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/expense_category/expense_category_controller.dart';
import 'package:ovosale/data/repo/expense_category/expense_category_repo.dart';
import '../../../core/app_permission/app_permission.dart';

class ExpenseCategoryScreen extends StatefulWidget {
  const ExpenseCategoryScreen({super.key});

  @override
  State<ExpenseCategoryScreen> createState() => _ExpenseCategoryScreenState();
}

class _ExpenseCategoryScreenState extends State<ExpenseCategoryScreen> {
  final ScrollController scrollController = ScrollController();
  void scrollListener() {
    if (scrollController.position.pixels ==
        scrollController.position.maxScrollExtent) {
      if (Get.find<ExpenseCategoryController>().hasNext()) {
        Get.find<ExpenseCategoryController>()
            .getExpenseCategoryData(isPagination: true);
      }
    }
  }

  Timer? _debounceTimer;
  @override
  void initState() {
    Get.put(ExpenseCategoryRepo());
    final controller =
        Get.put(ExpenseCategoryController(expenseCategoryRepo: Get.find()));
    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      scrollController.addListener(scrollListener);
      controller.getExpenseCategoryData();
    });
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<ExpenseCategoryController>(
      builder: (controller) => MyCustomScaffold(
        pageTitle: MyStrings.expenseCategory.tr,
        padding: EdgeInsets.zero,
        body: Column(
          children: [
            Container(
              padding: EdgeInsetsDirectional.symmetric(
                  horizontal: Dimensions.space16.w,
                  vertical: Dimensions.space12.h),
              color: MyColor.white,
              child: LabelTextField(
                labelText: "",
                hideLabel: true,
                controller: controller.searchExpenseCategoryController,
                hintText: MyStrings.search.tr,
                hintTextColor: MyColor.getBodyTextColor(),
                onChanged: (value) {
                  if (_debounceTimer?.isActive ?? false) {
                    _debounceTimer?.cancel();
                  }

                  _debounceTimer = Timer(const Duration(milliseconds: 500), () {
                    controller.getExpenseCategoryData();
                  });
                },
                textInputType: TextInputType.text,
                textInputAction: TextInputAction.done,
                radius: Dimensions.largeRadius,
                validator: (value) {
                  if (value!.isEmpty) {
                    return MyStrings.fieldErrorMsg.tr;
                  } else {
                    return null;
                  }
                },
                prefixIcon: Icon(
                  CupertinoIcons.search,
                  size: Dimensions.textFieldIconSize,
                ),
              ),
            ),
            spaceDown(Dimensions.space10),
            controller.isLoading
                ? CustomerDatabaseShimmer()
                : controller.filteredExpenseCategoryData.isEmpty &&
                        !controller.isLoading
                    ? Center(
                        child: SizedBox(
                          height: MediaQuery.of(context).size.height * 0.5,
                          child: NoDataWidget(),
                        ),
                      )
                    : Expanded(
                        child: CustomAppCard(
                            radius: 0,
                            showBorder: false,
                            child: ListView.separated(
                                controller: scrollController,
                                separatorBuilder: (context, index) =>
                                    CustomDivider(space: Dimensions.space16.h),
                                shrinkWrap: true,
                                itemCount: controller
                                        .filteredExpenseCategoryData.length +
                                    1,
                                itemBuilder: (context, i) {
                                  if (i ==
                                      controller
                                          .filteredExpenseCategoryData.length) {
                                    return controller.hasNext()
                                        ? SizedBox(
                                            height: Dimensions.space40,
                                            width: MediaQuery.of(context)
                                                .size
                                                .width,
                                            child: const CustomLoader(
                                                isPagination: true),
                                          )
                                        : const SizedBox();
                                  }
                                  return GestureDetector(
                                    child: ExpenseCategoryListTile(
                                      index: i,
                                    ),
                                  );
                                })),
                      )
          ],
        ),
        floatingActionButton: CustomAppCard(
            onPressed: () {
              if (controller.globalController.checkPermission(
                  featureName: AppPermissions.addExpenseCategory)) {
                Get.toNamed(RouteHelper.newExpenseCategoryScreen)?.then((v) {
                  controller.getExpenseCategoryData();
                });
              }
            },
            height: Dimensions.space64.h,
            width: Dimensions.space64.w,
            padding: EdgeInsetsDirectional.all(Dimensions.space20),
            backgroundColor: MyColor.getPrimaryColor(),
            showBorder: false,
            child: MyAssetImageWidget(
              color: theme.cardColor,
              assetPath: MyIcons.add,
              isSvg: true,
            )),
      ),
    );
  }
}
