import 'package:flutter/cupertino.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/core/utils/dimensions.dart';
import 'package:ovosale/core/utils/my_icons.dart';
import 'package:ovosale/data/controller/expense/expense_controller.dart';

class UpdateSectionPickImage extends StatelessWidget {
  const UpdateSectionPickImage({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<ExpenseController>(
      builder: (controller) => Container(
          margin: const EdgeInsets.all(Dimensions.space5),
          decoration: const BoxDecoration(),
          child: controller
                  .isImage(controller.selectedFile?.path.toString() ?? "")
              ? ClipRRect(
                  borderRadius: BorderRadius.circular(Dimensions.mediumRadius),
                  child: MyAssetImageWidget(
                    isFile: true,
                    assetPath: controller.selectedFile?.path ?? "",
                    width: 100,
                    height: 100,
                  ))
              : controller.isPdf(controller.selectedFile?.path.toString() ?? "")
                  ? MyAssetImageWidget(
                      isSvg: true,
                      assetPath: MyIcons.pdfFile,
                      width: 100,
                      height: 100,
                    )
                  : controller
                          .isDoc(controller.selectedFile?.path.toString() ?? "")
                      ? MyAssetImageWidget(
                          isSvg: true,
                          assetPath: MyIcons.doc,
                          width: 100,
                          height: 100,
                        )
                      : SizedBox()),
    );
  }
}
