import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/text-field/custom_drop_down_text_field.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/app/components/text/label_text.dart';
import 'package:ovosale/app/screens/brands/new_brand_screen.dart';
import 'package:ovosale/app/screens/expense/widgets/update_section_pick_image.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/expense/expense_controller.dart';

class UpdateExpensePopup extends StatefulWidget {
  final int index;
  final List<dynamic> expensesDataList;
  const UpdateExpensePopup({
    super.key,
    required this.index,
    required this.expensesDataList,
  });

  @override
  State<UpdateExpensePopup> createState() => _UpdateExpensePopupState();
}

class _UpdateExpensePopupState extends State<UpdateExpensePopup> {
  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<ExpenseController>(builder: (controller) {
      return Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: Row(
              children: [
                Expanded(
                    child: Text(MyStrings.updateExpense.tr.toString(),
                        style: theme.textTheme.headlineSmall)),
                GestureDetector(
                  onTap: () {
                    Get.back();
                  },
                  child: MyAssetImageWidget(
                    assetPath: MyIcons.popUpCancel,
                    height: Dimensions.space45.h,
                    width: Dimensions.space45.w,
                    isSvg: true,
                  ),
                )
              ],
            ),
          ),
          CustomDivider(),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              isRequired: true,
              onChanged: () {},
              readOnly: true,
              controller: controller.expenseDateController,
              labelText: MyStrings.expenseDate.tr,
              textInputType: TextInputType.phone,
              onTap: () {
                controller.changeEndSelectedDateOnlyValue(context);
              },
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          spaceDown(Dimensions.space16.h),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: CustomDropDownTextField(
              selectedValue: controller.selectedValue,
              onChanged: (value) {
                final selectedAttribute =
                    controller.expenseCategoryDataList.firstWhere(
                  (attribute) => attribute.name == value,
                );
                controller.selectedValue = value;
                controller.expensePurposeId = selectedAttribute.id ?? "";
                controller.update();
              },
              labelText: MyStrings.expensePurpose.tr,
              items: controller.expenseCategoryDataList.map((attribute) {
                return DropdownMenuItem<String>(
                  value: attribute.name,
                  child: Text(attribute.name ?? 'Unknown',
                      style: theme.textTheme.bodySmall),
                );
              }).toList(),
            ),
          ),
          spaceDown(Dimensions.space16.h),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              controller: controller.referenceController,
              labelText: MyStrings.referenceNo.tr,
              onChanged: (value) {},
              contentPadding: EdgeInsetsDirectional.symmetric(
                  vertical: Dimensions.space17.h,
                  horizontal: Dimensions.space16.w),
              textInputType: TextInputType.number,
              textInputAction: TextInputAction.done,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          spaceDown(Dimensions.space16.h),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              controller: controller.commentController,
              labelText: MyStrings.comment.tr,
              onChanged: (value) {},
              contentPadding: EdgeInsetsDirectional.symmetric(
                  vertical: Dimensions.space17.h,
                  horizontal: Dimensions.space16.w),
              textInputType: TextInputType.text,
              textInputAction: TextInputAction.done,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          spaceDown(Dimensions.space16.h),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              controller: controller.amountController,
              labelText: MyStrings.amount.tr,
              isRequired: true,
              onChanged: (value) {},
              contentPadding: EdgeInsetsDirectional.symmetric(
                  vertical: Dimensions.space17.h,
                  horizontal: Dimensions.space16.w),
              textInputType: TextInputType.number,
              textInputAction: TextInputAction.done,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          spaceDown(Dimensions.space16.h),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelText(
                text: MyStrings.attachment.tr,
                textStyle: theme.textTheme.labelMedium?.copyWith(
                    fontSize: Dimensions.space15.sp, color: MyColor.black),
                isRequired: true),
          ),
          spaceDown(Dimensions.space10.h),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: CustomPaint(
              painter: DottedBorderPainter(),
              child: CustomAppCard(
                showBorder: false,
                width: double.infinity,
                child: Stack(
                  children: [
                    Align(
                      alignment: Alignment.center,
                      child: GestureDetector(
                        onTap: () {
                          controller.pickFile();
                        },
                        child: controller.selectedFile == null
                            ? Column(
                                children: [
                                  MyAssetImageWidget(
                                      assetPath: MyIcons.addImage,
                                      isSvg: true,
                                      height: Dimensions.space56.h,
                                      width: Dimensions.space56.w,
                                      color: theme.primaryColor),
                                  Text(
                                    MyStrings.tapToAddImage.tr,
                                    style: theme.textTheme.bodyLarge?.copyWith(
                                      fontSize: Dimensions.space16.sp,
                                    ),
                                  )
                                ],
                              )
                            : UpdateSectionPickImage(),
                      ),
                    ),
                    if (controller.selectedFile != null)
                      Align(
                        alignment: Alignment
                            .topRight, // Position the button in the top-right
                        child: CustomAppCard(
                          onPressed: () {
                            controller.removeSelectedFile();
                          },
                          showBorder: false,
                          padding:
                              EdgeInsetsDirectional.all(Dimensions.space10),
                          radius: Dimensions.space8,
                          backgroundColor:
                              MyColor.getErrorColor().withValues(alpha: .2),
                          child: MyAssetImageWidget(
                            assetPath: MyIcons.delete,
                            isSvg: true,
                            height: Dimensions.space16.h,
                            width: Dimensions.space16.w,
                          ),
                        ),
                      ),
                  ],
                ),
              ),
            ),
          ),
          spaceDown(Dimensions.space10),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: Column(
              children: [
                spaceDown(Dimensions.space48.h),
                CustomElevatedBtn(
                  isLoading: controller.isSubmitting,
                  text: MyStrings.update.tr,
                  onTap: () {
                    controller.updateExpense(
                        widget.expensesDataList[widget.index].id.toString());
                  },
                  height: Dimensions.space56.h,
                  radius: Dimensions.largeRadius,
                ),
              ],
            ),
          ),
        ],
      );
    });
  }
}
