import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/alert-dialog/custom_alert_dialog.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/screens/expense/widgets/update_expense_popup.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/expense/expense_controller.dart';

import '../../../../core/app_permission/app_permission.dart';

class ExpenseListTile extends StatelessWidget {
  final int index;
  const ExpenseListTile({
    super.key,
    required this.index,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<ExpenseController>(
      builder: (controller) => ListTile(
          contentPadding: EdgeInsetsDirectional.zero,
          title: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(
                "${controller.getPurposeName(controller.filteredExpenseData[index].categoryId.toString())}  ",
                style: theme.textTheme.headlineSmall
                    ?.copyWith(fontWeight: FontWeight.w600),
              ),
              controller.filteredExpenseData[index].referenceNo.toString() !=
                      "null"
                  ? Text(
                      "${MyStrings.referenceNo.tr} : ${controller.filteredExpenseData[index].referenceNo.toString()}  ",
                      style: theme.textTheme.bodySmall
                          ?.copyWith(fontWeight: FontWeight.w600),
                    )
                  : const SizedBox(),
              Text(
                "${MyStrings.amount.tr} : ${AppConverter.formatNumber(controller.filteredExpenseData[index].amount.toString())} ${controller.defaultCurrency}",
                style: theme.textTheme.bodySmall
                    ?.copyWith(fontWeight: FontWeight.w600),
              ),
              Text(
                controller.filteredExpenseData[index].expenseDate.toString(),
                style: theme.textTheme.bodySmall,
              ),
            ],
          ),
          trailing: Row(mainAxisSize: MainAxisSize.min, children: [
            CustomAppCard(
              onPressed: () {
                if (controller.globalController
                    .checkPermission(featureName: AppPermissions.editExpense)) {
                  controller.getSelectedItemValue(index);
                  controller.getData();
                  CustomAlertDialog(
                    child: UpdateExpensePopup(
                      index: index,
                      expensesDataList: controller.filteredExpenseData,
                    ),
                  ).customAlertDialog(context);
                }
              },
              showBorder: false,
              padding: EdgeInsetsDirectional.all(Dimensions.space8),
              radius: Dimensions.space8,
              height: Dimensions.space32.h,
              width: Dimensions.space32.w,
              backgroundColor:
                  MyColor.getInformationColor().withValues(alpha: .2),
              child: MyAssetImageWidget(
                assetPath: MyIcons.edit,
                isSvg: true,
                height: Dimensions.space10.h,
                width: Dimensions.space16.w,
              ),
            ),
          ])),
    );
  }
}
