import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/advance_switch/custom_switch.dart';
import 'package:ovosale/app/components/alert-dialog/custom_alert_dialog.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/screens/customer/widgets/update_customer_pop_up.dart';
import 'package:ovosale/core/helper/date_converter.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/customer/customer_controller.dart';
import '../../../../core/app_permission/app_permission.dart';
import '../../../../data/controller/cart/global_controller.dart';

class CustomersListTile extends StatelessWidget {
  final bool isShowTrilling;
  final int index;
  const CustomersListTile(
      {super.key, required this.index, this.isShowTrilling = true});

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<CustomerController>(
      builder: (controller) => ListTile(
          contentPadding: EdgeInsetsDirectional.zero,
          title: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(
                controller.filteredCustomersDataList[index].name.toString(),
                style: theme.textTheme.headlineSmall
                    ?.copyWith(fontSize: Dimensions.space16.sp),
              ),
              Text(
                controller.filteredCustomersDataList[index].email.toString(),
                style: theme.textTheme.bodySmall
                    ?.copyWith(fontWeight: FontWeight.w600),
              ),
              Text(
                controller.filteredCustomersDataList[index].mobile.toString(),
                style: theme.textTheme.bodySmall
                    ?.copyWith(fontWeight: FontWeight.w600),
              ),
              Text(
                "${MyStrings.joinedAt.tr} : ${DateConverter.convertIsoToString(
                  controller.filteredCustomersDataList[index].createdAt
                      .toString(),
                )}",
                style: theme.textTheme.bodySmall
                    ?.copyWith(fontWeight: FontWeight.w600),
              ),
            ],
          ),
          trailing: isShowTrilling
              ? Row(mainAxisSize: MainAxisSize.min, children: [
                  CustomSwitch(
                    isLoading: controller.customerUpdateLoadingIndex ==
                        controller.filteredCustomersDataList[index].id,
                    value: controller.filteredCustomersDataList[index].status ==
                            "1"
                        ? true
                        : false,
                    onChanged: (v) {
                      controller.changeStatus(
                          controller.filteredCustomersDataList[index].id
                              .toString(),
                          index,
                          v);
                    },
                  ),
                  spaceSide(Dimensions.space12),
                  CustomAppCard(
                    onPressed: () {
                      if (Get.find<GlobalController>().checkPermission(
                          featureName: AppPermissions.editCustomer)) {
                        controller.getSelectedItemValue(
                          index,
                        );
                        CustomAlertDialog(
                          child: UpdateCustomersPopup(
                            index: index,
                          ),
                        ).customAlertDialog(context);
                      }
                    },
                    showBorder: false,
                    padding: EdgeInsetsDirectional.all(Dimensions.space8),
                    radius: Dimensions.space8,
                    height: Dimensions.space32.h,
                    width: Dimensions.space32.w,
                    backgroundColor:
                        MyColor.getInformationColor().withValues(alpha: .2),
                    child: MyAssetImageWidget(
                      assetPath: MyIcons.edit,
                      isSvg: true,
                      height: Dimensions.space10.h,
                      width: Dimensions.space16.w,
                    ),
                  ),
                ])
              : SizedBox()),
    );
  }
}
