import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/customer/add_new_customer_controller.dart';
import 'package:ovosale/data/repo/customer/new_customer_repo.dart';

class AddNewCustomerScreen extends StatefulWidget {
  const AddNewCustomerScreen({super.key});

  @override
  State<AddNewCustomerScreen> createState() => _AddNewCustomerScreenState();
}

class _AddNewCustomerScreenState extends State<AddNewCustomerScreen> {
  @override
  void initState() {
    Get.put(NewCustomerRepo());
    Get.put(AddNewCustomerController(newCustomerRepo: Get.find()));

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {});
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<AddNewCustomerController>(
      builder: (controller) => MyCustomScaffold(
        padding: EdgeInsetsDirectional.zero,
        pageTitle: MyStrings.newCustomer.tr,
        body: SingleChildScrollView(
          child: CustomAppCard(
              radius: 0,
              margin: EdgeInsetsDirectional.symmetric(
                  vertical: Dimensions.space10.h),
              showBorder: false,
              child: Column(children: [
                LabelTextField(
                  isRequired: true,
                  onChanged: () {},
                  controller: controller.customerNameController,
                  labelText: MyStrings.name.tr,
                  textInputType: TextInputType.emailAddress,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space10),
                LabelTextField(
                  isRequired: true,
                  onChanged: () {},
                  controller: controller.emailController,
                  labelText: MyStrings.email.tr,
                  textInputType: TextInputType.emailAddress,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space10),
                LabelTextField(
                  isRequired: true,
                  onChanged: () {},
                  controller: controller.phoneController,
                  labelText: MyStrings.phone.tr,
                  textInputType: TextInputType.phone,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space10),
                LabelTextField(
                  onChanged: () {},
                  controller: controller.addressController,
                  labelText: MyStrings.address.tr,
                  textInputType: TextInputType.phone,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space10),
                LabelTextField(
                  onChanged: () {},
                  controller: controller.cityController,
                  labelText: MyStrings.city.tr,
                  textInputType: TextInputType.emailAddress,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space10),
                LabelTextField(
                  onChanged: () {},
                  controller: controller.stateController,
                  labelText: MyStrings.state.tr,
                  textInputType: TextInputType.emailAddress,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space10),
                LabelTextField(
                  onChanged: () {},
                  controller: controller.zipController,
                  labelText: MyStrings.zipCode.tr,
                  textInputType: TextInputType.emailAddress,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space10),
                LabelTextField(
                  onChanged: () {},
                  controller: controller.postCodeController,
                  labelText: MyStrings.postCode.tr,
                  textInputType: TextInputType.emailAddress,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space10),
                LabelTextField(
                  onChanged: () {},
                  controller: controller.countryController,
                  labelText: MyStrings.country.tr,
                  textInputType: TextInputType.emailAddress,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space10),
                spaceDown(Dimensions.space15.h),
                CustomElevatedBtn(
                  isLoading: controller.isSubmitting,
                  text: MyStrings.save.tr,
                  onTap: () {
                    if (controller.customerNameController.text != "") {
                      if (controller.emailController.text != "") {
                        if (controller.phoneController.text != "") {
                          controller.createCustomer();
                        } else {
                          CustomSnackBar.error(
                              errorList: [MyStrings.nameisRequired.tr]);
                        }
                      } else {
                        CustomSnackBar.error(
                            errorList: [MyStrings.emailisRequired.tr]);
                      }
                    } else {
                      CustomSnackBar.error(
                          errorList: [MyStrings.phoneNumberisRequired.tr]);
                    }
                  },
                  height: Dimensions.space56.h,
                  radius: Dimensions.largeRadius,
                ),
              ])),
        ),
      ),
    );
  }
}
