import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/text-field/custom_drop_down_text_field.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/coupon/coupon_controller.dart';

class UpdateCouponPopup extends StatefulWidget {
  final int index;
  const UpdateCouponPopup({
    super.key,
    required this.index,
  });

  @override
  State<UpdateCouponPopup> createState() => _UpdateCouponPopupState();
}

class _UpdateCouponPopupState extends State<UpdateCouponPopup> {
  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<CouponController>(builder: (controller) {
      return Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: Row(
              children: [
                Expanded(
                    child: Text(MyStrings.updateCoupon.tr.toString(),
                        style: theme.textTheme.headlineSmall)),
                GestureDetector(
                  onTap: () {
                    Get.back();
                  },
                  child: MyAssetImageWidget(
                    assetPath: MyIcons.popUpCancel,
                    height: Dimensions.space45.h,
                    width: Dimensions.space45.w,
                    isSvg: true,
                  ),
                )
              ],
            ),
          ),
          CustomDivider(),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              onChanged: () {},
              controller: controller.couponNameController,
              labelText: MyStrings.couponName.tr,
              textInputType: TextInputType.emailAddress,
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          spaceDown(Dimensions.space10),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              onChanged: () {},
              controller: controller.couponCodeController,
              labelText: MyStrings.couponCode.tr,
              textInputType: TextInputType.emailAddress,
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          spaceDown(Dimensions.space10),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              onChanged: () {},
              controller: controller.minimumAmountController,
              labelText: MyStrings.minimumAmount.tr,
              textInputType: TextInputType.phone,
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          spaceDown(Dimensions.space10),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              onChanged: () {},
              controller: controller.amountController,
              labelText: MyStrings.amount.tr,
              textInputType: TextInputType.phone,
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          spaceDown(Dimensions.space10),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              onChanged: () {},
              controller: controller.maximumUsingTimeController,
              labelText: MyStrings.maximumUsingTime.tr,
              textInputType: TextInputType.emailAddress,
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          spaceDown(Dimensions.space10),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              onChanged: () {},
              controller: controller.descriptionController,
              labelText: MyStrings.description.tr,
              textInputType: TextInputType.emailAddress,
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          spaceDown(Dimensions.space10),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: CustomDropDownTextField(
              selectedValue: controller.selectedValue,
              onChanged: (value) {
                controller.selectedValue = value;
                controller.discountType = value.toString() == "%" ? "1" : "2";

                controller.update();
              },
              labelText: MyStrings.discountType.tr,
              items: controller.dropdownData.map((item) {
                return DropdownMenuItem(
                  value: item["label"],
                  child: Text(item["label"]!, style: theme.textTheme.bodySmall),
                );
              }).toList(),
            ),
          ),
          spaceDown(Dimensions.space10),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              isRequired: true,
              onChanged: () {},
              readOnly: true,
              controller: controller.startFromController,
              labelText: MyStrings.startFrom.tr,
              textInputType: TextInputType.phone,
              onTap: () {
                controller.changeSelectedDateOnlyValue(context);
              },
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          spaceDown(Dimensions.space10),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              isRequired: true,
              onChanged: () {},
              readOnly: true,
              controller: controller.endController,
              labelText: MyStrings.endAt.tr,
              textInputType: TextInputType.phone,
              onTap: () {
                controller.changeEndSelectedDateOnlyValue(context);
              },
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: Column(
              children: [
                spaceDown(Dimensions.space48.h),
                CustomElevatedBtn(
                  isLoading: controller.isSubmitting,
                  text: MyStrings.update.tr,
                  onTap: () {
                    controller.updateCoupon(controller
                        .filteredCouponListData[widget.index].id
                        .toString());
                  },
                  height: Dimensions.space56.h,
                  radius: Dimensions.largeRadius,
                ),
              ],
            ),
          ),
        ],
      );
    });
  }
}
