import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/advance_switch/custom_switch.dart';
import 'package:ovosale/app/components/alert-dialog/custom_alert_dialog.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/screens/coupon/widgets/update_coupon_pop_up.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/coupon/coupon_controller.dart';

import '../../../../core/app_permission/app_permission.dart';
import '../../../../data/controller/cart/global_controller.dart';

class CouponListTile extends StatelessWidget {
  final bool isFromSale;
  final int index;
  const CouponListTile({
    super.key,
    required this.index,
    required this.isFromSale,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<CouponController>(
      builder: (controller) => ListTile(
        contentPadding: EdgeInsetsDirectional.zero,
        title: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            isFromSale
                ? Text(
                    controller.couponData[index].name.toString(),
                    style: theme.textTheme.headlineSmall
                        ?.copyWith(fontSize: Dimensions.space16.sp),
                  )
                : Text(
                    controller.filteredCouponListData[index].name.toString(),
                    style: theme.textTheme.headlineSmall
                        ?.copyWith(fontSize: Dimensions.space16.sp),
                  ),
            isFromSale
                ? Text(
                    "${MyStrings.minimumAmount.tr} : ${controller.couponData[index].minimumAmount.toString()} ${controller.defaultCurrency}",
                    style: theme.textTheme.bodySmall
                        ?.copyWith(fontWeight: FontWeight.w600),
                  )
                : Text(
                    "${MyStrings.minimumAmount.tr} : ${controller.filteredCouponListData[index].minimumAmount.toString()} ${controller.defaultCurrency}",
                    style: theme.textTheme.bodySmall
                        ?.copyWith(fontWeight: FontWeight.w600),
                  ),
            isFromSale
                ? Text(
                    "${MyStrings.discount.tr} : ${AppConverter.formatNumber(controller.couponData[index].amount.toString())} ${controller.couponData[index].discountType.toString() == "2" ? controller.defaultCurrency : "%"}",
                    style: theme.textTheme.bodySmall
                        ?.copyWith(fontWeight: FontWeight.w600),
                  )
                : Text(
                    "${MyStrings.discount.tr} : ${AppConverter.formatNumber(controller.filteredCouponListData[index].amount.toString())} ${controller.filteredCouponListData[index].discountType.toString() == "2" ? controller.defaultCurrency : "%"}",
                    style: theme.textTheme.bodySmall
                        ?.copyWith(fontWeight: FontWeight.w600),
                  ),
            isFromSale
                ? Text(
                    "${MyStrings.expireAt.tr} : ${controller.couponData[index].endAt.toString()}",
                    style: theme.textTheme.bodySmall
                        ?.copyWith(fontWeight: FontWeight.w600),
                  )
                : Text(
                    "${MyStrings.expireAt.tr} : ${controller.filteredCouponListData[index].endAt.toString()}",
                    style: theme.textTheme.bodySmall
                        ?.copyWith(fontWeight: FontWeight.w600),
                  ),
            isFromSale
                ? Text(
                    "${MyStrings.totalUsed.tr} : ${controller.couponData[index].maximumUsingTime.toString()}",
                    style: theme.textTheme.bodySmall
                        ?.copyWith(fontWeight: FontWeight.w600),
                  )
                : Text(
                    "${MyStrings.totalUsed.tr} : ${controller.filteredCouponListData[index].maximumUsingTime.toString()}",
                    style: theme.textTheme.bodySmall
                        ?.copyWith(fontWeight: FontWeight.w600),
                  ),
          ],
        ),
        trailing: isFromSale
            ? GestureDetector(
                onTap: () {
                  controller.applyCoupon(coupon: controller.couponData[index]);
                },
                child: Container(
                  padding: const EdgeInsetsDirectional.symmetric(
                      horizontal: Dimensions.space22, vertical: 10),
                  decoration: BoxDecoration(
                      color: MyColor.getPrimaryColor(),
                      borderRadius: BorderRadius.circular(10)),
                  child: controller.couponData[index].isLoading
                      ? SizedBox(
                          width: 20,
                          height: 20,
                          child: CircularProgressIndicator(
                              color: MyColor.white, strokeWidth: 2))
                      : Text(
                          MyStrings.apply.tr,
                          style: theme.textTheme.titleSmall
                              ?.copyWith(fontSize: 14, color: MyColor.white),
                        ),
                ),
              )
            : Row(mainAxisSize: MainAxisSize.min, children: [
                CustomSwitch(
                  isLoading: controller.couponUpdateLoadingIndex ==
                      controller.filteredCouponListData[index].id,
                  value: controller.filteredCouponListData[index].status == "1"
                      ? true
                      : false,
                  onChanged: (v) {
                    controller.changeStatus(
                        controller.filteredCouponListData[index].id.toString(),
                        index,
                        v);
                  },
                ),
                spaceSide(Dimensions.space12),
                CustomAppCard(
                  onPressed: () {
                    if (Get.find<GlobalController>().checkPermission(
                        featureName: AppPermissions.editCoupon)) {
                      controller.getSelectedItemValue(index);
                      controller.getData(index);
                      CustomAlertDialog(
                        child: UpdateCouponPopup(
                          index: index,
                        ),
                      ).customAlertDialog(context);
                    }
                  },
                  showBorder: false,
                  padding: EdgeInsetsDirectional.all(Dimensions.space8),
                  radius: Dimensions.space8,
                  height: Dimensions.space32.h,
                  width: Dimensions.space32.w,
                  backgroundColor:
                      MyColor.getInformationColor().withValues(alpha: .2),
                  child: MyAssetImageWidget(
                    assetPath: MyIcons.edit,
                    isSvg: true,
                    height: Dimensions.space10.h,
                    width: Dimensions.space16.w,
                  ),
                ),
              ]),
      ),
    );
  }
}
