import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/app/components/text-field/custom_drop_down_text_field.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/coupon/add_new_coupon_controller.dart';
import 'package:ovosale/data/repo/coupon/add_new_coupon_repo.dart';

class AddNewCouponScreen extends StatefulWidget {
  const AddNewCouponScreen({super.key});

  @override
  State<AddNewCouponScreen> createState() => _AddNewCouponScreenState();
}

class _AddNewCouponScreenState extends State<AddNewCouponScreen> {
  @override
  void initState() {
    Get.put(AddNewCouponRepo());
    final controller =
        Get.put(AddNewCouponController(addNewCouponRepo: Get.find()));

    super.initState();
    controller.getData();
  }

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<AddNewCouponController>(
      builder: (controller) => MyCustomScaffold(
        padding: EdgeInsetsDirectional.zero,
        pageTitle: MyStrings.newCoupon.tr,
        body: SingleChildScrollView(
          child: CustomAppCard(
              radius: 0,
              margin: EdgeInsetsDirectional.symmetric(
                  vertical: Dimensions.space10.h),
              showBorder: false,
              child: Column(children: [
                LabelTextField(
                  isRequired: true,
                  onChanged: () {},
                  controller: controller.couponNameController,
                  labelText: MyStrings.couponName.tr,
                  textInputType: TextInputType.emailAddress,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space10),
                LabelTextField(
                  isRequired: true,
                  onChanged: () {},
                  controller: controller.couponCodeController,
                  labelText: MyStrings.couponCode.tr,
                  textInputType: TextInputType.emailAddress,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space10),
                LabelTextField(
                  isRequired: true,
                  onChanged: () {},
                  controller: controller.minimumAmountController,
                  labelText: MyStrings.minimumAmount.tr,
                  textInputType: TextInputType.number,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space10),
                CustomDropDownTextField(
                  selectedValue: controller.selectedValue,
                  onChanged: (value) {
                    controller.selectedValue = value;
                    controller.discountType =
                        value.toString() == "%" ? "1" : "2";

                    controller.update();
                  },
                  labelText: MyStrings.discountType,
                  items: controller.dropdownData.map((item) {
                    return DropdownMenuItem(
                      value: item["label"],
                      child: Text(item["label"]!,
                          style: theme.textTheme.bodySmall),
                    );
                  }).toList(),
                ),
                spaceDown(Dimensions.space10),
                LabelTextField(
                  isRequired: true,
                  onChanged: () {},
                  controller: controller.amountController,
                  labelText: MyStrings.amount.tr,
                  textInputType: TextInputType.phone,
                  hintText: controller.discountType == "1"
                      ? MyStrings.enterPercentage.tr
                      : MyStrings.enterFixedAmount.tr,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space15.h),
                LabelTextField(
                  isRequired: true,
                  onChanged: () {},
                  controller: controller.maximumUsingTimeController,
                  labelText: MyStrings.maximumUsingTime.tr,
                  textInputType: TextInputType.phone,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space15.h),
                LabelTextField(
                  isRequired: true,
                  onChanged: () {},
                  readOnly: true,
                  controller: controller.startFromController,
                  labelText: MyStrings.startFrom.tr,
                  textInputType: TextInputType.phone,
                  onTap: () {
                    controller.changeSelectedDateOnlyValue(context);
                  },
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space15.h),
                LabelTextField(
                  isRequired: true,
                  onChanged: () {},
                  readOnly: true,
                  controller: controller.endController,
                  labelText: MyStrings.endAt.tr,
                  textInputType: TextInputType.phone,
                  onTap: () {
                    controller.changeEndAtDateOnlyValue(context);
                  },
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space15.h),
                LabelTextField(
                  maxLines: 5,
                  onChanged: () {},
                  controller: controller.descriptionController,
                  labelText: MyStrings.description.tr,
                  textInputType: TextInputType.phone,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space15.h),
                CustomElevatedBtn(
                  isLoading: controller.isSubmitting,
                  text: MyStrings.save.tr,
                  onTap: () {
                    if (controller.couponNameController.text != "") {
                      if (controller.couponCodeController.text != "") {
                        if (controller.minimumAmountController.text != "") {
                          if (controller.amountController.text != "") {
                            if (controller.startFromController.text != "") {
                              if (controller.maximumUsingTimeController.text !=
                                  "") {
                                if (controller.endController.text != "") {
                                  controller.createCoupon();
                                } else {
                                  CustomSnackBar.error(errorList: [
                                    MyStrings.endDateisRequired.tr
                                  ]);
                                }
                              } else {
                                CustomSnackBar.error(errorList: [
                                  MyStrings.maximumUsingTimeisRequired.tr
                                ]);
                              }
                            } else {
                              CustomSnackBar.error(errorList: [
                                MyStrings.startDateisRequired.tr
                              ]);
                            }
                          } else {
                            CustomSnackBar.error(errorList: [
                              MyStrings.amountFieldisRequired.tr
                            ]);
                          }
                        } else {
                          CustomSnackBar.error(errorList: [
                            MyStrings.minimumAmountisRequired.tr
                          ]);
                        }
                      } else {
                        CustomSnackBar.error(
                            errorList: [MyStrings.couponCodeisReqired.tr]);
                      }
                    } else {
                      CustomSnackBar.error(
                          errorList: [MyStrings.couponNameisRequired.tr]);
                    }
                  },
                  height: Dimensions.space56.h,
                  radius: Dimensions.largeRadius,
                ),
              ])),
        ),
      ),
    );
  }
}
