import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/dialog/warning_dialog.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/image/my_network_image_widget.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/checkout/checkout_controller.dart';

import '../../../../data/services/shared_pref_service.dart';

class ItemIncreaseDecreaseSection extends StatelessWidget {
  const ItemIncreaseDecreaseSection({super.key});

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return Expanded(
      child: GetBuilder<CheckoutController>(
        builder: (controller) {
          return CustomAppCard(
            radius: 0,
            showBorder: false,
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: ListView.builder(
              physics: AlwaysScrollableScrollPhysics(),
              itemCount: controller.checkoutList.length,
              shrinkWrap: true,
              itemBuilder: (c, i) {
                var product = controller.checkoutList[i];
                // product.finalQuantity = AppConverter.toInt(product.quantity);

                return Column(
                  mainAxisSize: MainAxisSize.min,
                  children: [
                    CustomDivider(),
                    Row(
                      children: [
                        CustomAppCard(
                          height: Dimensions.space48.h,
                          width: Dimensions.space48.w,
                          padding: EdgeInsetsDirectional.all(Dimensions.space5),
                          backgroundColor: theme.cardColor,
                          showBorder: true,
                          radius: 10,
                          child: MyNetworkImageWidget(
                            imageUrl: product.imageSrc ?? "",
                            height: Dimensions.space60.h,
                            width: Dimensions.space60.w,
                            boxFit: BoxFit.cover,
                          ),
                        ),
                        SizedBox(
                          width: 10,
                        ),
                        Expanded(
                          flex: 3,
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            mainAxisSize: MainAxisSize.min,
                            children: [
                              Text(
                                product.name ?? "",
                                style: theme.textTheme.displayMedium?.copyWith(
                                  fontSize: Dimensions.space12.sp,
                                ),
                                maxLines: 1,
                                overflow: TextOverflow.ellipsis,
                              ),
                              Row(
                                mainAxisAlignment: MainAxisAlignment.start,
                                children: [
                                  Text(product.sku ?? "",
                                      style: theme.textTheme.labelSmall
                                          ?.copyWith(
                                              fontSize: Dimensions.space12.sp)),
                                  Padding(
                                    padding: const EdgeInsetsDirectional.all(
                                        Dimensions.space4),
                                    child: MyAssetImageWidget(
                                      assetPath: MyIcons.indicator,
                                      isSvg: true,
                                      height: Dimensions.space5,
                                      width: Dimensions.space5.w,
                                      color: MyColor.getBodyTextColor(),
                                    ),
                                  ),
                                  Expanded(
                                      child: Text(
                                          "${product.attributeName}: ${product.variantName}",
                                          style: theme.textTheme.labelSmall
                                              ?.copyWith(
                                                  fontSize:
                                                      Dimensions.space12.sp))),
                                ],
                              ),
                              SizedBox(height: 2.h),
                              Text(
                                "${SharedPreferenceService.getCurrencySymbol()}${controller.getSubTotal(saleProduct: product)}",
                                style: theme.textTheme.bodyLarge?.copyWith(
                                    fontWeight: FontWeight.w600,
                                    color: MyColor.lightPrimary,
                                    fontSize: 13.sp),
                                overflow: TextOverflow
                                    .ellipsis, // Prevents text overflow
                              ),
                            ],
                          ),
                        ),
                        SizedBox(width: 12.w),
                        Expanded(
                          flex: 4,
                          child: Row(
                            mainAxisSize: MainAxisSize.min,
                            children: [
                              GestureDetector(
                                onLongPress: () {
                                  controller.startDecreasing(product: product);
                                },
                                onLongPressEnd: (details) {
                                  controller.stopTimer();
                                  controller.updateQuantity(
                                      quantity: "${product.finalQuantity}",
                                      cartId: product.cardId ?? "-1");
                                },
                                onTap: () {
                                  controller.updateQuantity(
                                      quantity: "${product.finalQuantity - 1}",
                                      cartId: product.cardId ?? "-1");
                                },
                                child: MyAssetImageWidget(
                                  assetPath: MyIcons.roundedDecrease,
                                  isSvg: true,
                                  height: Dimensions.space22.h,
                                  width: Dimensions.space22.w,
                                ),
                              ),
                              spaceSide(Dimensions.space4.w),
                              Container(
                                padding: EdgeInsets.symmetric(vertical: 3),
                                alignment: Alignment.center,
                                width: 45,
                                decoration: BoxDecoration(
                                    borderRadius: BorderRadius.circular(8),
                                    border: Border.all(
                                        color: MyColor.getBorderColor())),
                                child: Text(
                                  "${product.finalQuantity}",
                                  style: theme.textTheme.titleSmall,
                                ),
                              ),
                              spaceSide(Dimensions.space4.w),
                              GestureDetector(
                                onLongPress: () {
                                  controller.startIncreasing(product: product);
                                },
                                onLongPressEnd: (details) {
                                  controller.stopTimer();
                                  controller.updateQuantity(
                                      quantity: "${product.finalQuantity}",
                                      cartId: product.cardId ?? "-1");
                                },
                                onTap: () {
                                  controller.updateQuantity(
                                      quantity: "${product.finalQuantity + 1}",
                                      cartId: product.cardId ?? "-1");
                                },
                                child: MyAssetImageWidget(
                                  assetPath: MyIcons.roundedIncrease,
                                  isSvg: true,
                                  height: Dimensions.space22.h,
                                  width: Dimensions.space22.w,
                                ),
                              ),
                              SizedBox(
                                width: 10.h,
                              ),
                              GestureDetector(
                                onTap: () {
                                  showWarningDialog(
                                      onTap: () {
                                        Get.back();
                                        controller.removeCart(
                                            cartId: product.cardId.toString());
                                      },
                                      context: context,
                                      desc:
                                          MyStrings.youWantToClearThisItem.tr);
                                },
                                child: Container(
                                    padding: EdgeInsets.all(4),
                                    decoration: BoxDecoration(
                                      color: theme.primaryColor
                                          .withValues(alpha: .1),
                                      shape: BoxShape.circle,
                                    ),
                                    child: controller.isRemoveCartLoadingID ==
                                            product.cardId.toString()
                                        ? SizedBox(
                                            width: Dimensions.space20,
                                            height: Dimensions.space20,
                                            child: CircularProgressIndicator(
                                              color: MyColor.getPrimaryColor(),
                                              strokeWidth: 1,
                                            ))
                                        : Icon(
                                            Icons.delete,
                                            size: 20,
                                            color: MyColor.lightError,
                                          )),
                              )
                            ],
                          ),
                        )
                      ],
                    ),
                  ],
                );
              },
            ),
          );
        },
      ),
    );
  }
}
