import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/dialog/warning_dialog.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/checkout/checkout_controller.dart';

class CheckoutTopSection extends StatelessWidget {
  const CheckoutTopSection({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<CheckoutController>(
      builder: (controller) => Container(
        margin: EdgeInsets.symmetric(vertical: Dimensions.space12.h),
        padding: EdgeInsetsDirectional.symmetric(
            horizontal: Dimensions.space16.w, vertical: Dimensions.space12.h),
        color: MyColor.white,
        child: Column(
          children: [
            Row(
              children: [
                Expanded(
                  child: CustomElevatedBtn(
                    text: MyStrings.addtoCart.tr,
                    onTap: () {
                      Get.back();
                    },
                    height: Dimensions.space56.h,
                    radius: Dimensions.largeRadius,
                  ),
                ),
                spaceSide(Dimensions.space12.w),
                Expanded(
                  child: CustomElevatedBtn(
                    isLoading: controller.isClearCartLoading,
                    bgColor: MyColor.getBodyTextColor().withValues(alpha: .10),
                    text: MyStrings.clearAllCart.tr,
                    onTap: () {
                      showWarningDialog(
                          onTap: () {
                            controller.clearCart();
                          },
                          context: context,
                          desc: MyStrings.youWantToClearThisCart.tr);
                    },
                    textColor: MyColor.getBodyTextColor(),
                    height: Dimensions.space56.h,
                    radius: Dimensions.largeRadius,
                  ),
                ),
              ],
            )
          ],
        ),
      ),
    );
  }
}
