import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/no_data.dart';
import 'package:ovosale/app/components/shimmer/checkout_shimmer.dart';
import 'package:ovosale/app/screens/checkout/widgets/checkout_top_section.dart';
import 'package:ovosale/app/screens/checkout/widgets/item_increase_decrease_Section.dart';
import 'package:ovosale/core/route/route.dart';
import 'package:ovosale/core/utils/util_exporter.dart';

import '../../../data/controller/checkout/checkout_controller.dart';
import '../../../data/repo/checkout/checkout_repo.dart';
import '../../../data/services/shared_pref_service.dart';

class CheckoutScreen extends StatefulWidget {
  const CheckoutScreen({super.key});

  @override
  State<CheckoutScreen> createState() => _CheckoutScreenState();
}

class _CheckoutScreenState extends State<CheckoutScreen> {
  @override
  void initState() {
    Get.put(CheckoutRepo());
    final controller = Get.put(CheckoutController(checkoutRepo: Get.find()));
    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.loadCheckoutData();
    });
  }

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<CheckoutController>(
      builder: (controller) => MyCustomScaffold(
        padding: EdgeInsetsDirectional.zero,
        pageTitle: MyStrings.checkout.tr,
        body: controller.isLoading
            ? CheckoutShimmer()
            : controller.checkoutList.isEmpty
                ? NoDataWidget()
                : Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      CheckoutTopSection(),
                      ItemIncreaseDecreaseSection()
                    ],
                  ),
        bottomNavigationBar: CustomAppCard(
            margin: EdgeInsets.symmetric(
                vertical: Dimensions.space25.h,
                horizontal: Dimensions.space16.w),
            onPressed: () {
              Get.toNamed(RouteHelper.billingSectionScreen);
            },
            width: double.infinity,
            padding: EdgeInsetsDirectional.all(Dimensions.space20),
            backgroundColor: MyColor.getPrimaryColor().withValues(alpha: .45),
            borderColor: theme.primaryColor,
            child: Row(
              children: [
                Expanded(
                    child: Text(MyStrings.totalPaybleAmount.tr,
                        style: theme.textTheme.headlineSmall)),
                CustomAppCard(
                    radius: Dimensions.space8,
                    backgroundColor: theme.primaryColor,
                    padding: EdgeInsetsDirectional.symmetric(
                        horizontal: Dimensions.space10,
                        vertical: Dimensions.space2.h),
                    showBorder: false,
                    child: Text(
                        "${SharedPreferenceService.getCurrencySymbol()}${controller.getTotalPayableAmount()}",
                        style: theme.textTheme.titleSmall?.copyWith(
                          color: MyColor.white,
                        )))
              ],
            )),
      ),
    );
  }
}
