import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/advance_switch/custom_switch.dart';
import 'package:ovosale/app/components/alert-dialog/custom_alert_dialog.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/image/my_network_image_widget.dart';
import 'package:ovosale/app/screens/category/widgets/edit_category_dialogue.dart';
import 'package:ovosale/core/helper/date_converter.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/category/category_controller.dart';

import '../../../../core/app_permission/app_permission.dart';
import '../../../../data/controller/cart/global_controller.dart';

class CategoryScreenListTile extends StatelessWidget {
  final int index;
  const CategoryScreenListTile({
    super.key,
    required this.index,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<CategoryController>(
      builder: (controller) => ListTile(
          contentPadding: EdgeInsetsDirectional.zero,
          leading: CustomAppCard(
            height: Dimensions.space56.h,
            width: Dimensions.space56.w,
            radius: Dimensions.space8,
            padding: EdgeInsetsDirectional.all(Dimensions.space4),
            child: MyNetworkImageWidget(
              imageUrl: controller.filteredCategories[index].imageSrc ?? "",
              height: Dimensions.space48.h,
              width: Dimensions.space48.w,
            ),
          ),
          title: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(
                controller.filteredCategories[index].name ?? "",
                style: theme.textTheme.headlineSmall
                    ?.copyWith(fontSize: Dimensions.space16.sp),
              ),
              Text(
                controller.filteredCategories[index].status == "1"
                    ? MyStrings.active.tr
                    : MyStrings.inActive.tr,
                style: theme.textTheme.bodySmall?.copyWith(
                    fontWeight: FontWeight.w600,
                    color: controller.filteredCategories[index].status == "1"
                        ? MyColor.getSuccessColor()
                        : MyColor.getErrorColor()),
              ),
              Row(
                children: [
                  Text(
                    "${MyStrings.createdAt.tr} : ",
                    style: theme.textTheme.bodySmall
                        ?.copyWith(fontWeight: FontWeight.w600),
                  ),
                  Text(
                    DateConverter.isoStringToLocalDateOnly(
                        controller.filteredCategories[index].createdAt ?? ""),
                    style: theme.textTheme.bodySmall,
                  ),
                ],
              )
            ],
          ),
          trailing: Row(mainAxisSize: MainAxisSize.min, children: [
            CustomSwitch(
              isLoading: controller.categoriesUpdateLoadingIndex ==
                  controller.filteredCategories[index].id,
              value: controller.filteredCategories[index].status == "1"
                  ? true
                  : false,
              onChanged: (v) {
                controller.changeStatus(
                    controller.filteredCategories[index].id.toString(),
                    index,
                    v);
              },
            ),
            spaceSide(Dimensions.space12),
            CustomAppCard(
                onPressed: () {
                  if (Get.find<GlobalController>().checkPermission(
                      featureName: AppPermissions.editCategory)) {
                    controller.categoryTextController.text =
                        controller.filteredCategories[index].name.toString();
                    CustomAlertDialog(
                        child: EditCategoryDialogue(
                      categoryId: controller.filteredCategories[index].id ?? "",
                    )).customAlertDialog(context);
                  }
                },
                showBorder: false,
                padding: EdgeInsetsDirectional.all(8),
                radius: Dimensions.space8,
                height: Dimensions.space32.h,
                width: Dimensions.space32.w,
                backgroundColor:
                    MyColor.getInformationColor().withValues(alpha: .2),
                child: MyAssetImageWidget(
                  assetPath: MyIcons.edit,
                  isSvg: true,
                  height: Dimensions.space10.h,
                  width: Dimensions.space16.w,
                )),
          ])),
    );
  }
}
