import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/pick_image/pick_image.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/app/components/text/label_text.dart';
import 'package:ovosale/app/screens/brands/new_brand_screen.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/brand/brand_controller.dart';

class UpdateBrandDialogue extends StatefulWidget {
  final String categoryId;
  const UpdateBrandDialogue({
    super.key,
    required this.categoryId,
  });

  @override
  State<UpdateBrandDialogue> createState() => _UpdateBrandDialogueState();
}

class _UpdateBrandDialogueState extends State<UpdateBrandDialogue> {
  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<BrandController>(builder: (controller) {
      return Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: Row(
              children: [
                Expanded(
                    child: Text(MyStrings.updateBrand.tr,
                        style: theme.textTheme.headlineSmall)),
                GestureDetector(
                  onTap: () {
                    Get.back();
                  },
                  child: MyAssetImageWidget(
                    assetPath: MyIcons.popUpCancel,
                    height: Dimensions.space45.h,
                    width: Dimensions.space45.w,
                    isSvg: true,
                  ),
                )
              ],
            ),
          ),
          CustomDivider(),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              onChanged: () {},
              controller: controller.brandNameController,
              labelText: MyStrings.name.tr,
              textInputType: TextInputType.emailAddress,
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          spaceDown(Dimensions.space15.h),
          Padding(
              padding: EdgeInsetsDirectional.symmetric(
                  horizontal: Dimensions.space16.w),
              child: Column(
                children: [
                  LabelText(
                      text: MyStrings.brandImage.tr,
                      textStyle: theme.textTheme.labelMedium?.copyWith(
                          fontSize: Dimensions.space15.sp,
                          color: MyColor.black),
                      isRequired: true),
                  spaceDown(Dimensions.space8.h),
                  CustomPaint(
                    painter: DottedBorderPainter(),
                    child: CustomAppCard(
                      onPressed: () {
                        controller.pickFile();
                      },
                      showBorder: false,
                      width: double.infinity,
                      child: Stack(
                        children: [
                          Align(
                            alignment: Alignment.center,
                            child: controller.selectedFile == null
                                ? Column(
                                    children: [
                                      MyAssetImageWidget(
                                          assetPath: MyIcons.addImage,
                                          isSvg: true,
                                          height: Dimensions.space56.h,
                                          width: Dimensions.space56.w,
                                          color: theme.primaryColor),
                                      Text(
                                        MyStrings.tapToAddImage.tr,
                                        style:
                                            theme.textTheme.bodyLarge?.copyWith(
                                          fontSize: Dimensions.space16.sp,
                                        ),
                                      )
                                    ],
                                  )
                                : PickImageSection(
                                    selectedFile: controller.selectedFile,
                                  ),
                          ),
                          if (controller.selectedFile != null)
                            Align(
                              alignment: Alignment
                                  .topRight, // Position the button in the top-right
                              child: CustomAppCard(
                                onPressed: () {
                                  controller.removeSelectedFile();
                                },
                                showBorder: false,
                                padding: EdgeInsetsDirectional.all(
                                    Dimensions.space10),
                                radius: Dimensions.space8,
                                backgroundColor: MyColor.getErrorColor()
                                    .withValues(alpha: .2),
                                child: MyAssetImageWidget(
                                  assetPath: MyIcons.delete,
                                  isSvg: true,
                                  height: Dimensions.space16.h,
                                  width: Dimensions.space16.w,
                                ),
                              ),
                            ),
                        ],
                      ),
                    ),
                  ),
                ],
              )),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: Column(
              children: [
                spaceDown(Dimensions.space48.h),
                CustomElevatedBtn(
                  isLoading: controller.submitLoading,
                  text: MyStrings.update.tr,
                  onTap: () {
                    controller.updateBrandData(widget.categoryId);
                  },
                  height: Dimensions.space56.h,
                  radius: Dimensions.largeRadius,
                ),
              ],
            ),
          ),
        ],
      );
    });
  }
}
