import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/advance_switch/custom_switch.dart';
import 'package:ovosale/app/components/alert-dialog/custom_alert_dialog.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/image/my_network_image_widget.dart';
import 'package:ovosale/app/screens/brands/widgets/update_brand_dialogue.dart';
import 'package:ovosale/core/helper/date_converter.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/brand/brand_controller.dart';
import 'package:ovosale/data/model/brand/brand_response_model.dart';

import '../../../../core/app_permission/app_permission.dart';
import '../../../../data/controller/cart/global_controller.dart';

class BrandScreenListTile extends StatelessWidget {
  final List<BrandData> brandDataList;
  final int index;
  const BrandScreenListTile({
    super.key,
    required this.brandDataList,
    required this.index,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<BrandController>(
      builder: (controller) => ListTile(
          contentPadding: EdgeInsetsDirectional.zero,
          leading: CustomAppCard(
            height: Dimensions.space40.h,
            width: Dimensions.space40.w,
            radius: Dimensions.space8,
            padding: EdgeInsetsDirectional.all(Dimensions.space4),
            child: MyNetworkImageWidget(
                imageUrl: brandDataList[index].imageSrc ?? ""),
          ),
          title: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(
                brandDataList[index].name ?? "",
                style: theme.textTheme.headlineSmall
                    ?.copyWith(fontSize: Dimensions.space16.sp),
              ),
              brandDataList[index].createdAt != "null"
                  ? Text(
                      DateConverter.convertIsoToString(
                          brandDataList[index].createdAt.toString()),
                      style: theme.textTheme.bodySmall
                          ?.copyWith(fontWeight: FontWeight.w600),
                    )
                  : SizedBox(),
            ],
          ),
          trailing: Row(mainAxisSize: MainAxisSize.min, children: [
            CustomSwitch(
              isLoading: controller.brandUpdateLoadingIndex ==
                  controller.filteredBrandDataList[index].id,
              value: controller.filteredBrandDataList[index].status == "1"
                  ? true
                  : false,
              onChanged: (v) {
                controller.changeStatus(
                    controller.filteredBrandDataList[index].id.toString(),
                    index,
                    v);
              },
            ),
            spaceSide(Dimensions.space12),
            CustomAppCard(
                onPressed: () {
                  if (Get.find<GlobalController>()
                      .checkPermission(featureName: AppPermissions.editBrand)) {
                    controller.brandNameController.text =
                        brandDataList[index].name.toString();
                    CustomAlertDialog(
                        child: UpdateBrandDialogue(
                      categoryId: brandDataList[index].id ?? "",
                    )).customAlertDialog(context);
                  }
                },
                showBorder: false,
                padding: EdgeInsetsDirectional.all(8),
                radius: Dimensions.space8,
                height: Dimensions.space32.h,
                width: Dimensions.space32.w,
                backgroundColor:
                    MyColor.getInformationColor().withValues(alpha: .2),
                child: MyAssetImageWidget(
                  assetPath: MyIcons.edit,
                  isSvg: true,
                  height: Dimensions.space10.h,
                  width: Dimensions.space16.w,
                )),
          ])),
    );
  }
}
