import 'dart:ui';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/pick_image/pick_image.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/app/components/text/label_text.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/new_brand/new_brand_controller.dart';
import 'package:ovosale/data/repo/new_brand/new_brand_repo.dart';

class NewBrandScreen extends StatefulWidget {
  const NewBrandScreen({super.key});

  @override
  State<NewBrandScreen> createState() => _NewBrandScreenState();
}

class _NewBrandScreenState extends State<NewBrandScreen> {
  @override
  void initState() {
    Get.put(NewBrandRepo());

    Get.put(NewBrandController(newBrandRepo: Get.find()));

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {});
  }

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<NewBrandController>(
      builder: (controller) => MyCustomScaffold(
        padding: EdgeInsetsDirectional.zero,
        pageTitle: MyStrings.newBrand.tr,
        body: SingleChildScrollView(
          child: CustomAppCard(
              radius: 0,
              margin: EdgeInsetsDirectional.symmetric(
                  vertical: Dimensions.space10.h),
              showBorder: false,
              child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    LabelTextField(
                      labelText: MyStrings.brandName.tr,
                      hintText: MyStrings.hintCategory.tr,
                      controller: controller.brandNameController,
                      isRequired: true,
                      onChanged: (value) {},
                      contentPadding: EdgeInsetsDirectional.symmetric(
                          vertical: Dimensions.space17.h,
                          horizontal: Dimensions.space16.w),
                      textInputType: TextInputType.text,
                      textInputAction: TextInputAction.done,
                      radius: Dimensions.largeRadius,
                      validator: (value) {
                        if (value!.isEmpty) {
                          return MyStrings.fieldErrorMsg.tr;
                        } else {
                          return null;
                        }
                      },
                    ),
                    spaceDown(Dimensions.space16.h),
                    LabelText(
                      text: MyStrings.brandImage.tr,
                      textStyle: theme.textTheme.labelMedium?.copyWith(
                          fontSize: Dimensions.space15.sp,
                          color: MyColor.black),
                    ),
                    spaceDown(Dimensions.space8.h),
                    CustomPaint(
                      painter: DottedBorderPainter(),
                      child: CustomAppCard(
                        onPressed: () {
                          controller.pickFile();
                        },
                        showBorder: false,
                        width: double.infinity,
                        child: Stack(
                          children: [
                            Align(
                              alignment: Alignment.center,
                              child: controller.selectedFile == null
                                  ? Column(
                                      children: [
                                        MyAssetImageWidget(
                                            assetPath: MyIcons.addImage,
                                            isSvg: true,
                                            height: Dimensions.space56.h,
                                            width: Dimensions.space56.w,
                                            color: theme.primaryColor),
                                        Text(
                                          MyStrings.tapToAddImage.tr,
                                          style: theme.textTheme.bodyLarge
                                              ?.copyWith(
                                            fontSize: Dimensions.space16.sp,
                                          ),
                                        )
                                      ],
                                    )
                                  : PickImageSection(
                                      selectedFile: controller.selectedFile,
                                    ),
                            ),
                            if (controller.selectedFile != null)
                              Align(
                                alignment: Alignment
                                    .topRight, // Position the button in the top-right
                                child: CustomAppCard(
                                  onPressed: () {
                                    controller.removeSelectedFile();
                                  },
                                  showBorder: false,
                                  padding: EdgeInsetsDirectional.all(
                                      Dimensions.space10),
                                  radius: Dimensions.space8,
                                  backgroundColor: MyColor.getErrorColor()
                                      .withValues(alpha: .2),
                                  child: MyAssetImageWidget(
                                    assetPath: MyIcons.delete,
                                    isSvg: true,
                                    height: Dimensions.space16.h,
                                    width: Dimensions.space16.w,
                                  ),
                                ),
                              ),
                          ],
                        ),
                      ),
                    ),
                    spaceDown(Dimensions.space16.h),
                    CustomElevatedBtn(
                      isLoading: controller.submitLoading,
                      text: MyStrings.save.tr,
                      onTap: () {
                        if (controller.brandNameController.text != "") {
                          controller.submitBrandData();
                        } else {
                          CustomSnackBar.error(
                              errorList: [MyStrings.brandNameIsRequired.tr]);
                        }
                      },
                      height: Dimensions.space56.h,
                      radius: Dimensions.largeRadius,
                    ),
                  ])),
        ),
      ),
    );
  }
}

class DottedBorderPainter extends CustomPainter {
  @override
  void paint(Canvas canvas, Size size) {
    final paint = Paint()
      ..color = MyColor.getPrimaryColor()
      ..strokeWidth = 2
      ..style = PaintingStyle.stroke;

    final double dashWidth = 3; // Width of each dash
    final double dashSpace = 2; // Space between each dash
    final double cornerRadius = 10; // Radius for rounded corners

    final path = Path()
      ..addRRect(RRect.fromRectAndRadius(
          Rect.fromLTWH(0, 0, size.width, size.height),
          Radius.circular(cornerRadius)));

    final PathMetrics pathMetrics = path.computeMetrics();

    for (PathMetric pathMetric in pathMetrics) {
      double distance = 0;
      while (distance < pathMetric.length) {
        final Tangent? tangent = pathMetric.getTangentForOffset(distance);
        if (tangent != null) {
          final Offset start = tangent.position;
          final Offset end = tangent.position +
              Offset(
                  dashWidth * tangent.vector.dx, dashWidth * tangent.vector.dy);
          canvas.drawLine(start, end, paint);
        }
        distance += dashWidth + dashSpace;
      }
    }
  }

  @override
  bool shouldRepaint(CustomPainter oldDelegate) => false;
}
