import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/core/app_permission/app_permission.dart';
import 'package:ovosale/core/route/route.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/product/product_controller.dart';
import 'package:ovosale/data/repo/product/product_repo.dart';

class ManageProductsScreen extends StatefulWidget {
  const ManageProductsScreen({super.key});

  @override
  State<ManageProductsScreen> createState() => _ManageProductsScreenState();
}

class _ManageProductsScreenState extends State<ManageProductsScreen> {
  @override
  void initState() {
    Get.put(ManageProductRepo());
    Get.put(ManageProductController(productRepo: Get.find()));

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {});
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<ManageProductController>(
      builder: (controller) => MyCustomScaffold(
        pageTitle: MyStrings.products.tr,
        isShowLeading: false,
        body: GridView.builder(
          physics: BouncingScrollPhysics(),
          itemCount: controller.productsData.length,
          shrinkWrap: true,
          gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
              crossAxisCount: 2,
              crossAxisSpacing: Dimensions.space16.w,
              mainAxisSpacing: Dimensions.space16.h),
          itemBuilder: (context, i) => CustomAppCard(
              padding: EdgeInsetsDirectional.all(Dimensions.space10.h),
              showBorder: false,
              onPressed: () {
                if (i == 0) {
                  if (controller.globalController.checkPermission(
                      featureName: AppPermissions.viewCategory)) {
                    Get.toNamed(RouteHelper.categoryScreen);
                  }
                }
                if (i == 1) {
                  if (controller.globalController.checkPermission(
                      featureName: AppPermissions.viewProduct)) {
                    Get.toNamed(RouteHelper.productsScreen);
                  }
                }

                if (i == 2) {
                  if (controller.globalController
                      .checkPermission(featureName: AppPermissions.viewBrand)) {
                    Get.toNamed(RouteHelper.brandScreen);
                  }
                }

                if (i == 3) {
                  if (controller.globalController
                      .checkPermission(featureName: AppPermissions.viewUnit)) {
                    Get.toNamed(RouteHelper.unitScreen);
                  }
                }

                if (i == 4) {
                  if (controller.globalController.checkPermission(
                      featureName: AppPermissions.viewAttribute)) {
                    Get.toNamed(RouteHelper.attributeScreen);
                  }
                }

                if (i == 5) {
                  if (controller.globalController.checkPermission(
                      featureName: AppPermissions.viewVariant)) {
                    Get.toNamed(RouteHelper.variantScreen);
                  }
                }
              },
              child: Center(
                child: Column(
                  mainAxisSize: MainAxisSize.min,
                  mainAxisAlignment: MainAxisAlignment.center,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    Expanded(
                      child: MyAssetImageWidget(
                          assetPath: controller.productsData[i]['image'],
                          isSvg: true,
                          color: theme.primaryColor),
                    ),
                    spaceDown(Dimensions.space4.h),
                    Flexible(
                        child: Text(
                      controller.productsData[i]['title'].toString(),
                      textAlign: TextAlign.center,
                      style: theme.textTheme.bodyMedium
                          ?.copyWith(fontSize: Dimensions.space17.sp),
                    ))
                  ],
                ),
              )),
        ),
      ),
    );
  }
}
