import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/custom_loader/custom_loader.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/image/my_network_image_widget.dart';
import 'package:ovosale/core/route/route.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/more/more_controller.dart';
import 'package:ovosale/data/repo/more/more_repo.dart';

import '../../../../core/app_permission/app_permission.dart';
import '../../../components/dialog/warning_dialog.dart';

class MoreScreen extends StatefulWidget {
  const MoreScreen({super.key});

  @override
  State<MoreScreen> createState() => _MoreScreenState();
}

class _MoreScreenState extends State<MoreScreen> {
  @override
  void initState() {
    Get.put(MoreRepo());
    final controller = Get.put(MoreController(moreRepo: Get.find()));
    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      print("calledddddddd");
      controller.getData();
    });
  }

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<MoreController>(
        builder: (controller) => Scaffold(
              backgroundColor: theme.scaffoldBackgroundColor,
              body: controller.loading
                  ? CustomLoader()
                  : Padding(
                      padding: EdgeInsetsDirectional.symmetric(
                          horizontal: Dimensions.space16),
                      child: Column(
                        children: [
                          spaceDown(Dimensions.space40),
                          CustomAppCard(
                            onPressed: () {
                              Get.toNamed(RouteHelper.profileScreen)?.then((v) {
                                controller.getData();
                              });
                            },
                            showBorder: false,
                            child: Row(
                              children: [
                                MyNetworkImageWidget(
                                  imageUrl: controller.userImage,
                                  height: Dimensions.space45.h,
                                  width: Dimensions.space45.w,
                                  radius: Dimensions.radiusProMax,
                                ),
                                spaceSide(Dimensions.space10),
                                Expanded(
                                  child: Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Text(
                                        controller.userName,
                                        style: theme.textTheme.bodyLarge
                                            ?.copyWith(
                                                fontWeight: FontWeight.w600),
                                      ),
                                      Text(
                                        controller.userRole,
                                        style: theme.textTheme.bodySmall,
                                      ),
                                    ],
                                  ),
                                ),
                              ],
                            ),
                          ),
                          spaceDown(Dimensions.space12),
                          Expanded(
                              child: SingleChildScrollView(
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Row(
                                  children: [
                                    Expanded(
                                      child: CustomAppCard(
                                        onPressed: () {
                                          if (controller.globalController
                                              .checkPermission(
                                                  featureName: AppPermissions
                                                      .viewWareHouse)) {
                                            Get.toNamed(
                                                RouteHelper.warehouseScreen,
                                                arguments: false);
                                          }
                                        },
                                        radius: Dimensions.space12,
                                        showBorder: false,
                                        child: Column(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.center,
                                          children: [
                                            MyAssetImageWidget(
                                                assetPath: MyIcons.warehouse,
                                                isSvg: true,
                                                height: Dimensions.space40.h,
                                                width: Dimensions.space40.w,
                                                color: theme.primaryColor),
                                            Text(
                                              MyStrings.warehouse.tr,
                                              style: theme.textTheme.bodyMedium,
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                    spaceSide(Dimensions.space16),
                                    Expanded(
                                      child: CustomAppCard(
                                        onPressed: () {
                                          if (controller.globalController
                                              .checkPermission(
                                                  featureName: AppPermissions
                                                      .viewPurchase)) {
                                            Get.toNamed(
                                                RouteHelper.purchaseScreen,
                                                arguments: false);
                                          }
                                        },
                                        radius: Dimensions.space12,
                                        showBorder: false,
                                        child: Column(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.center,
                                          children: [
                                            MyAssetImageWidget(
                                                assetPath: MyIcons.purchase,
                                                isSvg: true,
                                                height: Dimensions.space40.h,
                                                width: Dimensions.space40.w,
                                                color: theme.primaryColor),
                                            Text(
                                              MyStrings.purchase.tr,
                                              style: theme.textTheme.bodyMedium,
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                                spaceDown(Dimensions.space20),
                                Row(
                                  children: [
                                    Expanded(
                                      child: CustomAppCard(
                                        onPressed: () {
                                          if (controller.globalController
                                              .checkPermission(
                                                  featureName: AppPermissions
                                                      .viewCoupon)) {
                                            Get.toNamed(
                                                RouteHelper.couponScreen,
                                                arguments: false);
                                          }
                                        },
                                        radius: Dimensions.space12,
                                        showBorder: false,
                                        child: Column(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.center,
                                          children: [
                                            MyAssetImageWidget(
                                              assetPath: MyIcons.coupon,
                                              isSvg: true,
                                              color: theme.primaryColor,
                                              height: Dimensions.space40.h,
                                              width: Dimensions.space40.w,
                                            ),
                                            Text(
                                              MyStrings.coupon.tr,
                                              style: theme.textTheme.bodyMedium,
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                    spaceSide(Dimensions.space16),
                                    Expanded(
                                      child: CustomAppCard(
                                        onPressed: () {
                                          if (controller.globalController
                                              .checkPermission(
                                                  featureName: AppPermissions
                                                      .viewCustomer)) {
                                            Get.toNamed(
                                                RouteHelper.customerDataScreen,
                                                arguments: false);
                                          }
                                        },
                                        radius: Dimensions.space12,
                                        showBorder: false,
                                        child: Column(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.center,
                                          children: [
                                            MyAssetImageWidget(
                                                assetPath: MyIcons.addressBook,
                                                isSvg: true,
                                                height: Dimensions.space40.h,
                                                width: Dimensions.space40.w,
                                                color: theme.primaryColor),
                                            Text(
                                              MyStrings.customerDatabase.tr,
                                              style: theme.textTheme.bodyMedium,
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                                spaceDown(Dimensions.space20),
                                Row(
                                  children: [
                                    Expanded(
                                      child: CustomAppCard(
                                        onPressed: () {
                                          if (controller.globalController
                                              .checkPermission(
                                                  featureName: AppPermissions
                                                      .viewPaymentType)) {
                                            Get.toNamed(RouteHelper
                                                .paymentMethodScreen);
                                          }
                                        },
                                        radius: Dimensions.space12,
                                        showBorder: false,
                                        child: Column(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.center,
                                          children: [
                                            MyAssetImageWidget(
                                              assetPath: MyIcons.cardPayment,
                                              isSvg: true,
                                              height: Dimensions.space40.h,
                                              width: Dimensions.space40.w,
                                              color: theme.primaryColor,
                                            ),
                                            Text(
                                              MyStrings.paymentMethod.tr,
                                              style: theme.textTheme.bodyMedium,
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                    spaceSide(Dimensions.space16),
                                    Expanded(
                                      child: CustomAppCard(
                                        onPressed: () {
                                          if (controller.globalController
                                              .checkPermission(
                                                  featureName:
                                                      AppPermissions.viewTax)) {
                                            Get.toNamed(RouteHelper.taxScreen);
                                          }
                                        },
                                        showBorder: false,
                                        radius: Dimensions.space12,
                                        child: Column(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.center,
                                          children: [
                                            MyAssetImageWidget(
                                                assetPath:
                                                    MyIcons.taxandDiscount,
                                                isSvg: true,
                                                height: Dimensions.space40.h,
                                                width: Dimensions.space40.w,
                                                color: theme.primaryColor),
                                            Text(
                                              MyStrings.taxAndDiscount.tr,
                                              style: theme.textTheme.bodyMedium,
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                                spaceDown(Dimensions.space20),
                                Row(
                                  children: [
                                    Expanded(
                                      child: CustomAppCard(
                                        onPressed: () {
                                          if (controller.globalController
                                              .checkPermission(
                                                  featureName: AppPermissions
                                                      .viewSupplier)) {
                                            Get.toNamed(
                                                RouteHelper.supplierScreen);
                                          }
                                        },
                                        radius: Dimensions.space12,
                                        showBorder: false,
                                        child: Column(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.center,
                                          children: [
                                            MyAssetImageWidget(
                                              assetPath: MyIcons.supplier,
                                              isSvg: true,
                                              height: Dimensions.space40.h,
                                              width: Dimensions.space40.w,
                                              color: theme.primaryColor,
                                            ),
                                            Text(
                                              MyStrings.supplier.tr,
                                              style: theme.textTheme.bodyMedium,
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                    spaceSide(Dimensions.space16),
                                    Expanded(
                                      child: CustomAppCard(
                                        onPressed: () {
                                          if (controller.globalController
                                              .checkPermission(
                                                  featureName: AppPermissions
                                                      .viewExpense)) {
                                            Get.toNamed(
                                                RouteHelper.expenseScreen);
                                          }
                                        },
                                        showBorder: false,
                                        radius: Dimensions.space12,
                                        child: Column(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.center,
                                          children: [
                                            MyAssetImageWidget(
                                                assetPath: MyIcons.expense,
                                                isSvg: true,
                                                height: Dimensions.space40.h,
                                                width: Dimensions.space40.w,
                                                color: theme.primaryColor),
                                            Text(
                                              MyStrings.expense.tr,
                                              style: theme.textTheme.bodyMedium,
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                                spaceDown(Dimensions.space20),
                                Row(
                                  children: [
                                    Expanded(
                                      child: CustomAppCard(
                                        onPressed: () {
                                          if (controller.globalController
                                              .checkPermission(
                                                  featureName: AppPermissions
                                                      .viewSale)) {
                                            Get.toNamed(
                                                RouteHelper.saleListScreen);
                                          }
                                        },
                                        radius: Dimensions.space12,
                                        showBorder: false,
                                        child: Column(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.center,
                                          mainAxisAlignment:
                                              MainAxisAlignment.center,
                                          children: [
                                            MyAssetImageWidget(
                                                assetPath: MyIcons.sell,
                                                isSvg: true,
                                                height: Dimensions.space40.h,
                                                width: Dimensions.space40.w,
                                                color: theme.primaryColor),
                                            Text(
                                              MyStrings.sales.tr,
                                              style: theme.textTheme.bodyMedium,
                                              textAlign: TextAlign.center,
                                              maxLines: 1,
                                              overflow: TextOverflow.ellipsis,
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                    spaceSide(Dimensions.space16),
                                    Expanded(
                                      child: CustomAppCard(
                                        onPressed: () {
                                          if (controller.globalController
                                              .checkPermission(
                                                  featureName: AppPermissions
                                                      .viewExpenseCategory)) {
                                            Get.toNamed(RouteHelper
                                                .expenseCategoryScreen);
                                          }
                                        },
                                        radius: Dimensions.space12,
                                        showBorder: false,
                                        child: Column(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.center,
                                          children: [
                                            MyAssetImageWidget(
                                                assetPath:
                                                    MyIcons.expenseCategory,
                                                isSvg: true,
                                                height: Dimensions.space40.h,
                                                width: Dimensions.space40.w,
                                                color: theme.primaryColor),
                                            Text(
                                              MyStrings.expenseCategory.tr,
                                              style: theme.textTheme.bodyMedium,
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                                spaceDown(Dimensions.space20),
                                Row(
                                  children: [
                                    Expanded(
                                      child: CustomAppCard(
                                        onPressed: () {
                                          Get.toNamed(
                                              RouteHelper.settingsScreen);
                                        },
                                        radius: Dimensions.space12,
                                        showBorder: false,
                                        child: Column(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.center,
                                          children: [
                                            MyAssetImageWidget(
                                                assetPath: MyIcons.settings,
                                                isSvg: true,
                                                height: Dimensions.space40.h,
                                                width: Dimensions.space40.w,
                                                color: theme.primaryColor),
                                            Text(
                                              MyStrings.settings.tr,
                                              style: theme.textTheme.bodyMedium,
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                    spaceSide(Dimensions.space16),
                                    Expanded(
                                      child: CustomAppCard(
                                        onPressed: () {
                                          Get.toNamed(
                                              RouteHelper.languageScreen);
                                        },
                                        radius: Dimensions.space12,
                                        showBorder: false,
                                        child: Column(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.center,
                                          children: [
                                            MyAssetImageWidget(
                                                assetPath: MyIcons.language,
                                                isSvg: true,
                                                height: Dimensions.space40.h,
                                                width: Dimensions.space40.w,
                                                color: theme.primaryColor),
                                            Text(
                                              MyStrings.language.tr,
                                              style: theme.textTheme.bodyMedium,
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                                spaceDown(Dimensions.space20),
                                Row(
                                  children: [
                                    Expanded(
                                      child: CustomAppCard(
                                        onPressed: () {
                                          showWarningDialog(
                                              onTap: () {
                                                controller.logout();
                                              },
                                              context: context,
                                              desc: MyStrings
                                                  .areYouSureYouWanttoLogout
                                                  .tr);
                                        },
                                        radius: Dimensions.space12,
                                        showBorder: false,
                                        child: controller.logoutLoading
                                            ? SizedBox(
                                                height: 60.h,
                                                child: CustomLoader(
                                                  isPagination: true,
                                                ))
                                            : Column(
                                                crossAxisAlignment:
                                                    CrossAxisAlignment.center,
                                                children: [
                                                  MyAssetImageWidget(
                                                      assetPath: MyIcons.logout,
                                                      isSvg: true,
                                                      height:
                                                          Dimensions.space40.h,
                                                      width:
                                                          Dimensions.space40.w,
                                                      color:
                                                          theme.primaryColor),
                                                  Text(
                                                    MyStrings.logout.tr,
                                                    style: theme
                                                        .textTheme.bodyMedium,
                                                  ),
                                                ],
                                              ),
                                      ),
                                    ),
                                  ],
                                ),
                                spaceDown(Dimensions.space100 * 1.8),
                              ],
                            ),
                          )),
                        ],
                      ),
                    ),
            ));
  }
}
