import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/home/home_controller.dart';

class SalesCard extends StatefulWidget {
  const SalesCard({super.key});

  @override
  State<SalesCard> createState() => _SalesCardState();
}

class _SalesCardState extends State<SalesCard> {
  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<HomeController>(
      builder: (controller) => CustomAppCard(
        width: double.infinity,
        borderColor: theme.primaryColor,
        padding: EdgeInsetsDirectional.symmetric(
            horizontal: Dimensions.space16, vertical: Dimensions.space12),
        backgroundColor: theme.primaryColor.withValues(alpha: .06),
        radius: Dimensions.cardExtraRadius,
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Row(
              children: [
                Expanded(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(
                        MyStrings.totalSales.tr,
                        style: theme.textTheme.headlineSmall,
                      ),
                      Row(
                        children: [
                          Text(MyStrings.totalSales.tr,
                              style: theme.textTheme.labelSmall),
                          spaceSide(Dimensions.space5),
                          // Text(DateFormat("h:mm a").format(DateTime.now()),
                          Text(controller.totalSale,
                              style: theme.textTheme.labelSmall
                                  ?.copyWith(fontWeight: FontWeight.w600)),
                        ],
                      ),
                    ],
                  ),
                ),
                CustomAppCard(
                  radius: Dimensions.space8,
                  borderColor: theme.primaryColor.withValues(alpha: .25),
                  // padding: EdgeInsetsDirectional.all(Dimensions.space8),
                  padding:
                      const EdgeInsets.symmetric(horizontal: 12, vertical: 0),
                  backgroundColor: MyColor.transparent,
                  height: 32,
                  width: 125,
                  child: GetBuilder<HomeController>(
                    builder: (controller) => DropdownButton<String>(
                      borderRadius: BorderRadius.circular(10),
                      value: controller.selectedSalesType,
                      hint: const Text('Type'),
                      icon: MyAssetImageWidget(
                        assetPath: MyIcons.arrowDown,
                        isSvg: true,
                        height: Dimensions.space12.h,
                        width: Dimensions.space12.w,
                      ),
                      isExpanded: true,
                      underline: const SizedBox(),
                      items: controller.salesFilterTypeList.map((String item) {
                        return DropdownMenuItem<String>(
                          value: item,
                          child: Text(
                              item.tr.replaceAll("_", " ").toCapitalized(),
                              maxLines: 2,
                              overflow: TextOverflow.ellipsis,
                              style: theme.textTheme.titleSmall
                                  ?.copyWith(fontSize: 13)),
                          onTap: () {
                            controller.selectedSalesType = item;
                            controller.getSaleData();
                          },
                        );
                      }).toList(),
                      onChanged: (String? newValue) {},
                    ),
                  ),
                ),
              ],
            ),
            spaceDown(Dimensions.space32),
            Row(
              children: [
                Expanded(
                    child: Text(
                        "${controller.defaultCurrencySymbol}${AppConverter.formatNumber(controller.totalSaleAmount)}",
                        style: theme.textTheme.headlineLarge?.copyWith(
                          fontSize: Dimensions.space28.sp,
                        ))),
                spaceSide(Dimensions.space8.w),
              ],
            ),
          ],
        ),
      ),
    );
  }
}
