import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/core/app_permission/app_permission.dart';
import 'package:ovosale/core/route/route.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/cart/global_controller.dart';

class SaleAndPurchaseButtons extends StatelessWidget {
  const SaleAndPurchaseButtons({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<GlobalController>(
      builder: (controller) => Row(
        children: [
          Expanded(
            child: CustomElevatedBtn(
              bgColor: MyColor.getPrimaryColor(),
              text: MyStrings.newSale.tr,
              onTap: () {
                if (controller.checkPermission(featureName: AppPermissions.viewSale)) {
                  Get.toNamed(RouteHelper.newSaleScreen);
                }
              },
              height: Dimensions.space56.h,
              radius: Dimensions.largeRadius,
            ),
          ),
          spaceSide(Dimensions.space16),
          Expanded(
            child: CustomElevatedBtn(
              
              bgColor: MyColor.getSecondaryColor(),
              text: MyStrings.newPurchase.tr,
              onTap: () {
                if (controller.checkPermission(featureName: AppPermissions.addPurchase)) {
                  Get.toNamed(RouteHelper.newPurchaseScreen);
                }
              },
              height: Dimensions.space56.h,
              radius: Dimensions.largeRadius,
            ),
          ),
        ],
      ),
    );
  }
}
