import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/screens/bottom_nav_section/home/widget/recent_transaction_list_tile.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/util_exporter.dart';

import '../../../../../data/controller/home/home_controller.dart';

class RecentTransactions extends StatefulWidget {
  const RecentTransactions({super.key});

  @override
  State<RecentTransactions> createState() => _RecentTransactionsState();
}

class _RecentTransactionsState extends State<RecentTransactions> {
  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<HomeController>(
      builder: (controller) => CustomAppCard(
        borderColor: MyColor.transparent,
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Row(
              children: [
                Expanded(
                    child: Text(MyStrings.recentTransaction.tr,
                        style: theme.textTheme.headlineSmall?.copyWith(
                            color: MyColor.black,
                            fontSize: Dimensions.space16.sp))),
                CustomAppCard(
                  radius: Dimensions.space8,
                  borderColor: theme.primaryColor.withValues(alpha: .25),
                  // padding: EdgeInsetsDirectional.all(Dimensions.space8),
                  padding:
                      const EdgeInsets.symmetric(horizontal: 12, vertical: 0),
                  backgroundColor: MyColor.transparent,
                  height: 32,
                  width: 120,
                  child: GetBuilder<HomeController>(
                    builder: (controller) => DropdownButton<String>(
                      borderRadius: BorderRadius.circular(10),
                      value: controller.selectedTransactionType,
                      hint: Text('Type'.tr),
                      icon: MyAssetImageWidget(
                        assetPath: MyIcons.arrowDown,
                        isSvg: true,
                        height: Dimensions.space12.h,
                        width: Dimensions.space12.w,
                      ),
                      isExpanded: true,
                      underline: const SizedBox(),
                      items: controller.transactionFilterTypeList
                          .map((String item) {
                        return DropdownMenuItem<String>(
                          value: item,
                          child: Text(item.tr.toCapitalized(),
                              maxLines: 2,
                              overflow: TextOverflow.ellipsis,
                              style: theme.textTheme.titleSmall
                                  ?.copyWith(fontSize: 13)),
                          onTap: () {
                            controller.selectedTransactionType = item;
                            controller.getRecentTransactionData();
                          },
                        );
                      }).toList(),
                      onChanged: (String? newValue) {},
                    ),
                  ),
                ),
              ],
            ),
            ListView.separated(
                separatorBuilder: (context, index) {
                  return CustomPaint(
                    painter: DashedBorderPainter(),
                  );
                },
                padding: EdgeInsets.zero,
                physics: const NeverScrollableScrollPhysics(),
                itemCount: controller.recentTransactionsList.length,
                shrinkWrap: true,
                itemBuilder: (context, index) {
                  var transaction = controller.recentTransactionsList[index];
                  return RecentTransactionListTile(
                    recentTransaction: transaction,
                  );
                })
          ],
        ),
      ),
    );
  }
}

class DashedBorderPainter extends CustomPainter {
  @override
  void paint(Canvas canvas, Size size) {
    final paint = Paint()
      ..color = MyColor.getBorderColor()
      ..strokeWidth = 1
      ..style = PaintingStyle.stroke;

    double dashWidth = 6, dashSpace = 4;
    final path = Path();
    for (double x = 0; x < size.width; x += dashWidth + dashSpace) {
      path.moveTo(x, 0);
      path.lineTo(x + dashWidth, 0);
    }
    canvas.drawPath(path, paint);
  }

  @override
  bool shouldRepaint(CustomPainter oldDelegate) => false;
}
