import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/custom_loader/custom_loader.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/core/app_permission/app_permission.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/home/home_controller.dart';
import 'package:ovosale/data/controller/file_download/file_downloader.dart';
import 'package:ovosale/data/model/dashboard/recent_transaction_response_model.dart';

class RecentTransactionListTile extends StatelessWidget {
  final RecentTransaction recentTransaction;

  const RecentTransactionListTile({super.key, required this.recentTransaction});

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<HomeController>(
      builder: (controller) => ListTile(
        contentPadding: EdgeInsets.zero,
        title: Row(
          children: [
            Expanded(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Text(
                    "${MyStrings.invoiceId.tr}: ${recentTransaction.invoiceNumber}",
                    style: theme.textTheme.headlineSmall
                        ?.copyWith(fontSize: Dimensions.space16.sp),
                  ),
                  spaceDown(Dimensions.space4),
                  Text(
                      "${MyStrings.orderAmount.tr} ${controller.defaultCurrencySymbol}${AppConverter.formatNumber(recentTransaction.total ?? "")} ",
                      style: theme.textTheme.bodySmall),
                  spaceDown(Dimensions.space4),
                  Text("${MyStrings.date.tr} ${recentTransaction.purchaseDate}",
                      style: theme.textTheme.bodySmall),
                ],
              ),
            ),
            CustomAppCard(
              onPressed: () async {
                if (controller.globalController.checkPermission(
                    featureName: AppPermissions.downloadPurchaseInvoice,
                    isShowSnackBar: true)) {
                  AnyFileDownloaderAndOpener pdfDownloader =
                      AnyFileDownloaderAndOpener();

                  String url =
                      "${UrlContainer.baseUrl}${UrlContainer.downloadPdfEndPoint}/${recentTransaction.id}";

                  recentTransaction.isLoading = true;
                  controller.update();
                  await pdfDownloader.downloadAnyFile(url: url).then((value) {
                    recentTransaction.isLoading = false;
                    controller.update();
                  });
                }
              },
              radius: Dimensions.space8,
              borderColor: theme.primaryColor,
              padding: EdgeInsetsDirectional.symmetric(
                  horizontal: Dimensions.space16.w,
                  vertical: Dimensions.space10.w),
              backgroundColor: MyColor.transparent,
              child: recentTransaction.isLoading
                  ? SizedBox(width: 88, child: CustomLoader())
                  : Row(
                      children: [
                        MyAssetImageWidget(
                          assetPath: MyIcons.invoice,
                          isSvg: true,
                          height: Dimensions.space20.h,
                          width: Dimensions.space20.w,
                        ),
                        spaceSide(Dimensions.space4),
                        Text(
                          MyStrings.invoice.tr,
                          style: theme.textTheme.labelLarge?.copyWith(
                              fontWeight: FontWeight.w600,
                              color: MyColor.getPrimaryColor()),
                        ),
                      ],
                    ),
            ),
          ],
        ),
      ),
    );
  }
}
