import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:intl/intl.dart';
import 'package:ovosale/app/components/cart_count_widget.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/image/my_network_image_widget.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/home/home_controller.dart';

class HomeTopSection extends StatelessWidget {
  const HomeTopSection({super.key});

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<HomeController>(
      builder: (controller) => Padding(
        padding: const EdgeInsets.symmetric(horizontal: 16),
        child: Row(
          children: [
            Expanded(
              child: Row(
                children: [
                  MyNetworkImageWidget(
                    imageUrl: controller.adminInfo?.imageSrc ?? "",
                    height: Dimensions.space45.h,
                    width: Dimensions.space45.w,
                    radius: Dimensions.radiusProMax,
                  ),
                  spaceSide(Dimensions.space10),
                  Expanded(
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          controller.adminInfo?.username ?? "",
                          style: theme.textTheme.bodyLarge
                              ?.copyWith(fontWeight: FontWeight.w600),
                        ),
                        Row(
                          children: [
                            MyAssetImageWidget(
                                assetPath: MyImages.clock,
                                isSvg: true,
                                height: Dimensions.space16.h,
                                width: Dimensions.space16.w,
                                color: theme.primaryColor),
                            spaceSide(Dimensions.space2),
                            Expanded(
                              child: Text(
                                DateFormat("h:mm a • d MMMM yyyy")
                                    .format(DateTime.now()),
                                style: theme.textTheme.bodySmall,
                              ),
                            ),
                          ],
                        )
                      ],
                    ),
                  ),
                ],
              ),
            ),
            CartCountWidget(),
          ],
        ),
      ),
    );
  }
}
