import 'package:fl_chart/fl_chart.dart';
import 'package:flutter/material.dart';
import 'package:ovosale/data/controller/home/home_controller.dart';

class SalesPurchaseChart extends StatelessWidget {
  const SalesPurchaseChart({super.key, required this.controller});
  final HomeController controller;

  @override
  Widget build(BuildContext context) {
    return Builder(builder: (context) {
      return Padding(
        padding: const EdgeInsets.symmetric(horizontal: 0, vertical: 10),
        child: BarChart(
          BarChartData(
            alignment: BarChartAlignment.spaceAround,
            maxY: controller.maxValue +
                20, // Slightly higher than max value for padding
            barGroups: controller.barGroups,
            titlesData: FlTitlesData(
              leftTitles: AxisTitles(
                sideTitles: SideTitles(
                    showTitles: true, reservedSize: 50, maxIncluded: false),
              ),
              bottomTitles: AxisTitles(
                sideTitles: SideTitles(
                  showTitles: true,
                  getTitlesWidget: (double value, _) {
                    int index = value.toInt();
                    return Text(controller.dates[index],
                        style: const TextStyle(
                          color: Color(0xff7589a2),
                          fontWeight: FontWeight.bold,
                          fontSize: 14,
                        ));
                  },
                ),
              ),
              rightTitles: const AxisTitles(
                sideTitles: SideTitles(showTitles: false),
              ),
              topTitles: const AxisTitles(
                sideTitles: SideTitles(showTitles: false),
              ),
            ),

            gridData: FlGridData(show: true),
            borderData: FlBorderData(show: false),
          ),
        ),
      );
    });
  }
}
