import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/shimmer/dashboard_shimmer.dart';
import 'package:ovosale/app/screens/bottom_nav_section/home/widget/bar_chart.dart';
import 'package:ovosale/app/screens/bottom_nav_section/home/widget/home_top_section.dart';
import 'package:ovosale/app/screens/bottom_nav_section/home/widget/recent_transactions.dart';
import 'package:ovosale/app/screens/bottom_nav_section/home/widget/sale_and_purchase_buttons.dart';
import 'package:ovosale/app/screens/bottom_nav_section/home/widget/sales_card.dart';
import 'package:ovosale/core/app_permission/app_permission.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/home/home_controller.dart';
import 'package:ovosale/data/controller/file_download/file_downloader.dart';
import 'package:ovosale/data/repo/home/home_repo.dart';
import '../../../components/divider/custom_divider.dart';
import '../../../components/image/my_asset_widget.dart';

class HomeScreen extends StatefulWidget {
  final GlobalKey<ScaffoldState> bottomNavScaffoldKey;
  const HomeScreen({super.key, required this.bottomNavScaffoldKey});

  @override
  State<HomeScreen> createState() => _HomeScreenState();
}

class _HomeScreenState extends State<HomeScreen> {
  @override
  void initState() {
    Get.put(HomeRepo());
    final controller = Get.put(HomeController(homeRepo: Get.find()));
    Get.put(AnyFileDownloaderAndOpener());
    controller.isLoading = true;
    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.initialData();
    });
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<HomeController>(
      builder: (controller) => RefreshIndicator(
        onRefresh: () async {
          controller.initialData();
        },
        child: Scaffold(
          backgroundColor: theme.scaffoldBackgroundColor,
          body: controller.isLoading
              ? const DashboardShimmer()
              : Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    SizedBox(height: Dimensions.space45),
                    HomeTopSection(),
                    spaceDown(Dimensions.space24),
                    Expanded(
                        child: SingleChildScrollView(
                      padding: EdgeInsetsDirectional.symmetric(
                          horizontal: Dimensions.space16.w),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          SalesCard(),
                          spaceDown(Dimensions.space24),
                          SaleAndPurchaseButtons(),
                          spaceDown(Dimensions.space24),
                          Visibility(
                            visible: controller.globalController
                                .checkPermission(
                                    featureName: AppPermissions.viewDashboard,
                                    isShowSnackBar: false),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Padding(
                                  padding:
                                      const EdgeInsets.symmetric(horizontal: 5),
                                  child: Row(
                                    mainAxisAlignment:
                                        MainAxisAlignment.spaceBetween,
                                    children: [
                                      Column(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Text(MyStrings.lastFiveDays.tr,
                                              style:
                                                  theme.textTheme.labelSmall),
                                          Text(MyStrings.purchasedSales.tr,
                                              style: theme.textTheme.bodyLarge
                                                  ?.copyWith(
                                                      fontSize:
                                                          Dimensions.space17.sp,
                                                      fontWeight:
                                                          FontWeight.w600,
                                                      color: MyColor.black))
                                        ],
                                      ),
                                      Column(
                                        mainAxisSize: MainAxisSize.min,
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Row(
                                            children: [
                                              MyAssetImageWidget(
                                                assetPath: MyIcons.indicator,
                                                isSvg: true,
                                                height: Dimensions.space8.h,
                                                width: Dimensions.space8.w,
                                                color:
                                                    MyColor.getSecondaryColor(),
                                              ),
                                              spaceSide(Dimensions.space4),
                                              Text(MyStrings.purchase.tr,
                                                  style: theme
                                                      .textTheme.bodySmall
                                                      ?.copyWith(
                                                          fontWeight:
                                                              FontWeight.w600,
                                                          fontSize: Dimensions
                                                              .space11.sp))
                                            ],
                                          ),
                                          spaceDown(Dimensions.space4),
                                          Row(
                                            children: [
                                              MyAssetImageWidget(
                                                assetPath: MyIcons.indicator,
                                                isSvg: true,
                                                height: Dimensions.space8.h,
                                                width: Dimensions.space8.w,
                                                color:
                                                    MyColor.getPrimaryColor(),
                                              ),
                                              spaceSide(Dimensions.space4),
                                              Text(MyStrings.sales.tr,
                                                  style: theme
                                                      .textTheme.bodySmall
                                                      ?.copyWith(
                                                          fontWeight:
                                                              FontWeight.w600,
                                                          fontSize: Dimensions
                                                              .space11.sp))
                                            ],
                                          ),
                                        ],
                                      )
                                    ],
                                  ),
                                ),
                                CustomDivider(space: 15),
                                SizedBox(
                                    height: 272.h,
                                    child: SalesPurchaseChart(
                                      controller: controller,
                                    )),
                                spaceDown(Dimensions.space24),
                              ],
                            ),
                          ),
                          Visibility(
                              visible:
                                  controller.recentTransactionsList.isNotEmpty,
                              child: RecentTransactions()),
                          spaceDown(Dimensions.space100),
                        ],
                      ),
                    )),
                  ],
                ),
        ),
      ),
    );
  }
}
