import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/divider/custom_dashed_divider.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/checkout/checkout_controller.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';

class ItemInfoSection extends StatefulWidget {
  const ItemInfoSection({super.key});

  @override
  State<ItemInfoSection> createState() => _ItemInfoSectionState();
}

class _ItemInfoSectionState extends State<ItemInfoSection> {
  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<CheckoutController>(
      builder: (controller) => CustomAppCard(
          showBorder: false,
          padding: EdgeInsetsDirectional.zero,
          child: Column(
            mainAxisSize: MainAxisSize.min,
            children: [
              Container(
                  padding: EdgeInsetsDirectional.symmetric(
                      vertical: Dimensions.space7.h,
                      horizontal: Dimensions.space8.w),
                  decoration: BoxDecoration(
                      color:
                          MyColor.getInformationColor().withValues(alpha: .1),
                      borderRadius: BorderRadius.only(
                          topLeft: Radius.circular(Dimensions.space15),
                          topRight: Radius.circular(Dimensions.space15))),
                  child: Row(
                    children: [
                      Expanded(
                          flex: 3,
                          child: Text(MyStrings.itemInfo.tr,
                              style: theme.textTheme.bodyMedium?.copyWith(
                                  fontWeight: FontWeight.w600,
                                  color: MyColor.black))),
                      spaceSide(Dimensions.space10),
                      Expanded(
                          child: Text(MyStrings.qty.tr,
                              textAlign: TextAlign.center,
                              style: theme.textTheme.bodyMedium?.copyWith(
                                  fontWeight: FontWeight.w600,
                                  color: MyColor.black))),
                      spaceSide(Dimensions.space10),
                      Expanded(
                          flex: 2,
                          child: Text(MyStrings.price.tr,
                              textAlign: TextAlign.end,
                              style: theme.textTheme.bodyMedium?.copyWith(
                                  fontWeight: FontWeight.w600,
                                  color: MyColor.black)))
                    ],
                  )),
              ListView.separated(
                  physics: NeverScrollableScrollPhysics(),
                  separatorBuilder: (context, index) => CustomDashedDivider(
                        color: theme.dividerColor,
                        height: .7,
                        dashWidth: Dimensions.space3,
                        dashSpace: Dimensions.space2,
                      ),
                  shrinkWrap: true,
                  itemCount: controller.checkoutList.length,
                  itemBuilder: (c, i) {
                    var checkoutItem = controller.checkoutList[i];

                    return Padding(
                      padding: EdgeInsets.symmetric(
                          vertical: Dimensions.space12.h,
                          horizontal: Dimensions.space8.w),
                      child: Row(
                        children: [
                          Expanded(
                              flex: 3,
                              child: Text(checkoutItem.name ?? '',
                                  textAlign: TextAlign.start,
                                  maxLines: 1,
                                  overflow: TextOverflow.ellipsis,
                                  style: theme.textTheme.bodyMedium?.copyWith(
                                      fontSize: Dimensions.space15.sp,
                                      color: MyColor.black))),
                          spaceSide(Dimensions.space10),
                          Expanded(
                              child: Text("x${checkoutItem.quantity} ",
                                  textAlign: TextAlign.center,
                                  style: theme.textTheme.bodyMedium?.copyWith(
                                      fontSize: Dimensions.space15.sp,
                                      color: MyColor.black))),
                          spaceSide(Dimensions.space10),
                          Expanded(
                              flex: 2,
                              child: Text(
                                  "${SharedPreferenceService.getCurrencySymbol()}${controller.getSubTotal(saleProduct: checkoutItem)}",
                                  textAlign: TextAlign.end,
                                  style: theme.textTheme.bodyMedium?.copyWith(
                                      fontWeight: FontWeight.w600,
                                      color: MyColor.black)))
                        ],
                      ),
                    );
                  }),
              Padding(
                padding:
                    const EdgeInsets.symmetric(horizontal: Dimensions.space8),
                child: CustomDivider(
                    height: Dimensions.space2, space: Dimensions.space12),
              ),
              Padding(
                padding: const EdgeInsetsDirectional.symmetric(
                    horizontal: Dimensions.space8),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Text(MyStrings.subTotal.tr,
                        style: theme.textTheme.bodyMedium?.copyWith(
                            fontSize: Dimensions.space15.sp,
                            color: MyColor.black,
                            fontWeight: FontWeight.w600)),
                    Text(
                        "${SharedPreferenceService.getCurrencySymbol()}${controller.getTotalPayableAmount()}",
                        style: theme.textTheme.bodyMedium?.copyWith(
                            fontSize: Dimensions.space15.sp,
                            color: MyColor.black,
                            fontWeight: FontWeight.w600))
                  ],
                ),
              ),
              spaceDown(Dimensions.space10)
            ],
          )),
    );
  }
}
