import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:get/get.dart';

import '../../../../core/utils/my_color.dart';
import '../../../../core/utils/my_strings.dart';
import '../../../../core/utils/style.dart';
import '../../../../data/controller/billing_section/billing_section_controller.dart';
import '../../../components/buttons/rounded_button.dart';
import '../../../components/search_text_field2.dart';

class DiscountDialog extends StatelessWidget {
  const DiscountDialog({
    super.key,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return Dialog(
        child: GetBuilder<BillingSectionController>(
      builder: (controller) => Container(
        padding: EdgeInsets.all(16),
        width: context.width * .6,
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(10),
          color: theme.scaffoldBackgroundColor,
        ),
        child: Stack(
          children: [
            Column(
              mainAxisSize: MainAxisSize.min,
              children: [
                Text(MyStrings.addDiscount.tr,
                    style: theme.textTheme.titleSmall),
                SizedBox(
                  height: 14,
                ),
                Row(
                  children: [
                    Expanded(
                      child: TextField2(
                        controller: controller.discountAmountController,
                        radius: 8,
                        keyboardType: TextInputType.number,
                        contentPadding: EdgeInsets.symmetric(horizontal: 10),
                        hintText:
                            controller.selectedDiscountType == MyStrings.fixed
                                ? MyStrings.amount.tr
                                : MyStrings.percent.tr,
                        fillColor: MyColor.getBorderColor(),
                        borderColor: MyColor.getBorderColor(),
                      ),
                    ),
                    SizedBox(width: 10.h),
                    Container(
                      width: 100,
                      padding: const EdgeInsets.symmetric(
                          horizontal: 12, vertical: 0),
                      decoration: BoxDecoration(
                        color: MyColor.getBorderColor(),
                        border: Border.all(
                            color: MyColor.white, width: .7), // Add border
                        borderRadius: BorderRadius.circular(
                            8), // Optional for rounded corners
                      ),
                      child: GetBuilder<BillingSectionController>(
                        builder: (controller) => DropdownButton<String>(
                          value: controller.selectedDiscountType,
                          hint: const Text('Type'),
                          icon: const Icon(Icons.arrow_drop_down),
                          isExpanded: true,
                          underline: const SizedBox(),
                          items: controller.discountTypeList.map((String item) {
                            return DropdownMenuItem<String>(
                              value: item,
                              child: Text(
                                item,
                                maxLines: 2,
                                overflow: TextOverflow.ellipsis,
                                style: mediumDefault.copyWith(),
                              ),
                              onTap: () {
                                controller.selectedDiscountType = item;
                                controller.discountAmountController.text =
                                    "0.0";
                                controller.update();
                              },
                            );
                          }).toList(),
                          onChanged: (String? newValue) {},
                        ),
                      ),
                    ),
                  ],
                ),
                SizedBox(
                  height: 14.h,
                ),
                RoundedButton(
                  color: theme.primaryColor,
                  text: MyStrings.apply.tr,
                  onPress: () {
                    controller.onDiscountApplyTap();
                  },
                )
              ],
            ),
            Positioned(
                right: 0,
                top: 0,
                child: GestureDetector(
                  onTap: () {
                    controller.discountAmountController.clear();
                    controller.discountAmount = 0.00;
                    controller.discountPercent = "0";
                    controller.update();
                    Get.back();
                  },
                  child: Container(
                      color: theme.scaffoldBackgroundColor,
                      child: Icon(
                        Icons.close,
                        size: 20,
                      )),
                ))
          ],
        ),
      ),
    ));
  }
}
