import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:get/get.dart';

import '../../../../core/utils/my_color.dart';
import '../../../../core/utils/my_strings.dart';
import '../../../../data/controller/billing_section/billing_section_controller.dart';
import '../../../components/buttons/rounded_button.dart';
import '../../../components/search_text_field2.dart';

class DeliveryChargeDialog extends StatelessWidget {
  const DeliveryChargeDialog({
    super.key,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return Dialog(
        child: GetBuilder<BillingSectionController>(
      builder: (controller) => Container(
        padding: EdgeInsets.all(16),
        width: context.width * .6,
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(10),
          color: theme.scaffoldBackgroundColor,
        ),
        child: Stack(
          children: [
            Column(
              mainAxisSize: MainAxisSize.min,
              children: [
                Text(MyStrings.deliveryCharge.tr,
                    style: theme.textTheme.titleSmall),
                SizedBox(
                  height: 14,
                ),
                TextField2(
                  controller: controller.deliveryChargeController,
                  radius: 8,
                  keyboardType: TextInputType.number,
                  contentPadding: EdgeInsets.symmetric(horizontal: 10),
                  hintText: MyStrings.amount.tr,
                  fillColor: MyColor.getBorderColor(),
                  borderColor: MyColor.getBorderColor(),
                ),
                SizedBox(
                  height: 14.h,
                ),
                RoundedButton(
                  color: theme.primaryColor,
                  text: MyStrings.apply.tr,
                  onPress: () {
                    controller.onDeliveryChargeApplyTap();
                  },
                )
              ],
            ),
            Positioned(
                right: 0,
                top: 0,
                child: GestureDetector(
                  onTap: () {
                    controller.deliveryChargeController.clear();
                    controller.deliveryCharge = 0.00;
                    controller.update();
                    Get.back();
                  },
                  child: Container(
                      color: theme.scaffoldBackgroundColor,
                      child: Icon(
                        Icons.close,
                        size: 20,
                      )),
                ))
          ],
        ),
      ),
    ));
  }
}
