import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/core/utils/util_exporter.dart';

class BillingCard extends StatelessWidget {
  final String leadingTxt;
  final String amount;
  final String toolTipTxt;
  final bool isShowEditButton;
  final VoidCallback? onTap;

  const BillingCard(
      {super.key,
      required this.leadingTxt,
      required this.amount,
      this.isShowEditButton = true,
      this.toolTipTxt = "",
      this.onTap});

  @override
  Widget build(BuildContext context) {
    final GlobalKey<TooltipState> tooltipKey = GlobalKey<TooltipState>();

    ThemeData theme = Theme.of(context);
    return CustomAppCard(
        height: 56.h,
        padding: EdgeInsetsDirectional.only(
            start: Dimensions.space8.w,
            end: isShowEditButton ? Dimensions.space7.w : Dimensions.space14.w),
        showBorder: false,
        radius: Dimensions.space12,
        child: Row(
          children: [
            Text(leadingTxt.tr,
                style: theme.textTheme.titleSmall?.copyWith(
                    fontSize: Dimensions.space15.sp, color: MyColor.black)),
            spaceSide(Dimensions.space4),
            Tooltip(
                key: tooltipKey,
                message: toolTipTxt.tr,
                preferBelow: false,
                child: GestureDetector(
                  onTap: () {
                    tooltipKey.currentState?.ensureTooltipVisible();
                  },
                  child: MyAssetImageWidget(
                      assetPath: MyIcons.info,
                      isSvg: true,
                      height: Dimensions.space16.h,
                      width: Dimensions.space16.w,
                      color: MyColor.getPrimaryColor()),
                )),
            Spacer(),
            Text(amount,
                style: theme.textTheme.titleSmall?.copyWith(
                    fontSize: Dimensions.space15.sp, color: MyColor.black)),
            if (isShowEditButton) ...[
              spaceSide(Dimensions.space16),
              GestureDetector(
                onTap: onTap,
                child: CustomAppCard(
                    backgroundColor: theme.primaryColor.withValues(alpha: .15),
                    showBorder: false,
                    padding: EdgeInsetsDirectional.all(Dimensions.space12),
                    radius: Dimensions.space11,
                    child: MyAssetImageWidget(
                        assetPath: MyIcons.editFramed,
                        isSvg: true,
                        color: theme.primaryColor,
                        height: Dimensions.space24.h,
                        width: Dimensions.space24.w)),
              )
            ]
          ],
        ));
  }
}
