import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/screens/billing/widgets/billing_card.dart';
import 'package:ovosale/app/screens/billing/widgets/delivery_charge_dialog.dart';
import 'package:ovosale/app/screens/billing/widgets/discount_dialog.dart';
import 'package:ovosale/app/screens/billing/widgets/item_info_section.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/route/route.dart';
import 'package:ovosale/core/utils/util_exporter.dart';

import '../../../data/controller/billing_section/billing_section_controller.dart';
import '../../../data/repo/billing_section/billing_section_repo.dart';
import '../../../data/services/shared_pref_service.dart';

class BillingSectionScreen extends StatefulWidget {
  const BillingSectionScreen({super.key});

  @override
  State<BillingSectionScreen> createState() => _BillingSectionScreenState();
}

class _BillingSectionScreenState extends State<BillingSectionScreen> {
  @override
  void initState() {
    Get.put(BillingSectionRepo());
    final controller =
        Get.put(BillingSectionController(billingSectionRepo: Get.find()));
    controller.getDefaultCurrency();
    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {});
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<BillingSectionController>(
        builder: (controller) => MyCustomScaffold(
              pageTitle: MyStrings.billingSection.tr,
              body: SingleChildScrollView(
                child: Column(
                  children: [
                    ItemInfoSection(),
                    spaceDown(Dimensions.space12),
                    BillingCard(
                      leadingTxt: "(-) ${MyStrings.coupon.tr}",
                      amount:
                          "${controller.defaultCurrency}${AppConverter.formatNumber(controller.couponAmount.toString())}",
                      toolTipTxt: controller.couponAmount > 0
                          ? "Coupon applied"
                          : "Coupon not applied",
                      onTap: () {
                        Get.toNamed(RouteHelper.couponScreen, arguments: true)
                            ?.then((value) => controller.update());
                      },
                    ),
                    spaceDown(Dimensions.space12),
                    BillingCard(
                      onTap: () {
                        controller.discountAmountController.text =
                            AppConverter.formatNumber(
                                controller.discountAmount.toString());
                        if (controller.currentDiscountType ==
                            MyStrings.percent) {
                          controller.discountAmountController.text =
                              "${controller.discountPercent}%";
                        }
                        // controller.selectedDiscountType = MyStrings.fixed;
                        showDialog(
                          context: context,
                          builder: (context) {
                            return DiscountDialog();
                          },
                        ).then((value) {
                          if (value == null) {
                            controller.selectedDiscountType =
                                controller.currentDiscountType;
                          }
                        });
                      },
                      leadingTxt: "(-) ${MyStrings.discount.tr}",
                      amount:
                          "${controller.defaultCurrency}${AppConverter.formatNumber(controller.discountAmount.toString())}",
                      toolTipTxt: controller.discountAmount > 0
                          ? "Discount added"
                          : "No discount added",
                    ),
                    spaceDown(Dimensions.space12),
                    BillingCard(
                      onTap: () {
                        showDialog(
                          context: context,
                          builder: (context) {
                            return DeliveryChargeDialog();
                          },
                        );
                      },
                      leadingTxt: "(+) ${MyStrings.shippingCharge.tr}",
                      amount:
                          "${controller.defaultCurrency}${AppConverter.formatNumber(controller.deliveryCharge.toString())}",
                      toolTipTxt: controller.discountAmount > 0
                          ? "Delivery charge added"
                          : "No delivery charge added",
                    ),
                  ],
                ),
              ),
              bottomNavigationBar: CustomAppCard(
                  margin: EdgeInsets.symmetric(
                      vertical: Dimensions.space15.h,
                      horizontal: Dimensions.space16.w),
                  onPressed: () {
                    Get.toNamed(RouteHelper.paymentScreen);
                  },
                  width: double.infinity,
                  padding: EdgeInsetsDirectional.all(Dimensions.space20),
                  backgroundColor:
                      MyColor.getPrimaryColor().withValues(alpha: .45),
                  borderColor: theme.primaryColor,
                  child: Row(
                    children: [
                      Expanded(
                          child: Text(MyStrings.continuetoCheckout.tr,
                              style: theme.textTheme.headlineSmall)),
                      CustomAppCard(
                          radius: Dimensions.space8,
                          backgroundColor: theme.primaryColor,
                          padding: EdgeInsetsDirectional.symmetric(
                              horizontal: Dimensions.space10,
                              vertical: Dimensions.space2.h),
                          showBorder: false,
                          child: Text(
                              "${SharedPreferenceService.getCurrencySymbol()}${controller.getTotal()}",
                              style: theme.textTheme.headlineSmall?.copyWith(
                                color: MyColor.white,
                              )))
                    ],
                  )),
            ));
  }
}
