import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/annotated_region/annotated_region_widget.dart';
import 'package:ovosale/app/components/bottom-sheet/bottom_sheet_bar.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/core/route/route.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/auth/login_controller.dart';
import 'package:ovosale/data/repo/auth/login_repo.dart';

class LoginScreen extends StatefulWidget {
  const LoginScreen({super.key});

  @override
  State<LoginScreen> createState() => _LoginScreenState();
}

class _LoginScreenState extends State<LoginScreen> {
  final formKey = GlobalKey<FormState>();

  @override
  void initState() {
    Get.put(LoginRepo());
    Get.put(LoginController(loginRepo: Get.find()));

    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((_) {
      Get.find<LoginController>().remember = false;
    });
  }

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return AnnotatedRegionWidget(
      statusBarBrightness: Brightness.dark,
      statusBarIconBrightness: Brightness.light,
      statusBarColor: MyColor.transparent,
      child: Scaffold(
        backgroundColor: theme.scaffoldBackgroundColor,
        body: GetBuilder<LoginController>(
          builder: (controller) => Stack(
            children: [
              Align(
                alignment: Alignment.topCenter,
                child: SizedBox(
                    width: double.infinity,
                    height: context.height * .7,
                    child: MyAssetImageWidget(
                      radius: 0,
                      assetPath: MyImages.gradientEffect,
                      boxFit: BoxFit.cover,
                    )),
              ),
              Align(
                alignment: Alignment.topLeft,
                child: Container(
                    margin: EdgeInsetsDirectional.only(
                        top: Dimensions.space30, start: Dimensions.space16),
                    width: 200,
                    child: MyAssetImageWidget(
                      assetPath: MyImages.appLogo,
                      boxFit: BoxFit.contain,
                    )),
              ),

              Container(
                  margin: EdgeInsetsDirectional.only(
                      start: Dimensions.space16.h, end: Dimensions.space30.w),
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: [
                      Text(MyStrings.letsGettoWork.tr,
                          style: theme.textTheme.headlineLarge?.copyWith(
                              fontSize: Dimensions.space35.sp,
                              color: MyColor.white)),
                      Text(MyStrings.loginToStartManagingYourBusiness.tr,
                          style: theme.textTheme.labelLarge?.copyWith(
                              fontSize: Dimensions.space17.sp,
                              color: MyColor.white.withValues(alpha: .85)))
                    ],
                  )),

              // Content Section
              DraggableScrollableSheet(
                initialChildSize: 0.4,
                minChildSize: 0.4,
                maxChildSize: 0.7,
                builder: (context, scrollController) {
                  return CustomAppCard(
                    showBorder: false,
                    borderRadius: BorderRadiusDirectional.only(
                      topStart: Radius.circular(Dimensions.space20),
                      topEnd: Radius.circular(Dimensions.space20),
                    ),
                    child: SingleChildScrollView(
                      controller:
                          scrollController, // Attach the scroll controller here
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: [
                          BottomSheetBar(),
                          Form(
                            key: formKey,
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                LabelTextField(
                                  onChanged: () {},
                                  hintText: MyStrings.hintNameOrEmail.tr,
                                  controller: controller.emailController,
                                  labelText: MyStrings.usernameOrEmail.tr,
                                  focusNode: controller.emailFocusNode,
                                  nextFocus: controller.passwordFocusNode,
                                  textInputType: TextInputType.emailAddress,
                                  textInputAction: TextInputAction.next,
                                  radius: Dimensions.largeRadius,
                                  validator: (value) {
                                    if (value!.isEmpty) {
                                      return MyStrings.fieldErrorMsg.tr;
                                    } else {
                                      return null;
                                    }
                                  },
                                  prefixIcon: MyAssetImageWidget(
                                      width: Dimensions.space20,
                                      assetPath: MyIcons.user,
                                      isSvg: true,
                                      height: Dimensions.space20,
                                      boxFit: BoxFit.scaleDown,
                                      color: theme.primaryColor),
                                ),
                                const SizedBox(height: Dimensions.space20),
                                LabelTextField(
                                  onChanged: () {},
                                  hintText: MyStrings.passwordHint.tr,
                                  labelText: MyStrings.password.tr,
                                  controller: controller.passwordController,
                                  focusNode: controller.passwordFocusNode,
                                  isPassword: true,
                                  textInputType: TextInputType.text,
                                  textInputAction: TextInputAction.done,
                                  radius: Dimensions.largeRadius,
                                  validator: (value) {
                                    if (value!.isEmpty) {
                                      return MyStrings.fieldErrorMsg.tr;
                                    } else {
                                      return null;
                                    }
                                  },
                                  prefixIcon: MyAssetImageWidget(
                                      width: Dimensions.space20,
                                      assetPath: MyIcons.password,
                                      isSvg: true,
                                      height: Dimensions.space20,
                                      boxFit: BoxFit.scaleDown,
                                      color: theme.primaryColor),
                                ),
                                const SizedBox(height: 25),
                                Align(
                                  alignment: Alignment.centerRight,
                                  child: InkWell(
                                    onTap: () {
                                      controller.clearTextField();
                                      Get.toNamed(
                                          RouteHelper.forgotPasswordScreen);
                                    },
                                    child: Text(
                                      MyStrings.forgotPassword.tr,
                                      style:
                                          theme.textTheme.bodyMedium?.copyWith(
                                        color: theme.primaryColor,
                                        fontWeight: FontWeight.w600,
                                      ),
                                    ),
                                  ),
                                ),
                                spaceDown(Dimensions.space20),
                                CustomElevatedBtn(
                                  isLoading: controller.isSubmitLoading,
                                  text: MyStrings.login.tr,
                                  onTap: () {
                                    if (formKey.currentState!.validate()) {
                                      controller.loginUser();
                                    }
                                  },
                                  height: Dimensions.space56.h,
                                  radius: Dimensions.largeRadius,
                                ),
                                spaceDown(Dimensions.space20),
                              ],
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            ],
          ),
        ),
      ),
    );
  }
}
