import 'package:flutter/material.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:get/get.dart';
import 'package:ovosale/core/route/route.dart';
import 'package:ovosale/core/utils/dimensions.dart';
import 'package:ovosale/core/utils/my_color.dart';
import 'package:ovosale/core/utils/my_icons.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/core/utils/style.dart';
import 'package:ovosale/data/controller/auth/forget_password/reset_password_controller.dart';
import 'package:ovosale/data/repo/auth/login_repo.dart';
import 'package:ovosale/app/components/text/default_text.dart';
import 'package:ovosale/app/components/text/header_text.dart';
import 'package:ovosale/app/components/will_pop_widget.dart';

class ResetPasswordScreen extends StatefulWidget {
  const ResetPasswordScreen({super.key});

  @override
  State<ResetPasswordScreen> createState() => _ResetPasswordScreenState();
}

class _ResetPasswordScreenState extends State<ResetPasswordScreen> {
  final formKey = GlobalKey<FormState>();

  @override
  void initState() {
    Get.put(LoginRepo());
    final controller = Get.put(ResetPasswordController(loginRepo: Get.find()));

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.email = Get.arguments[0];
      controller.code = Get.arguments[1];
    });
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return WillPopWidget(
      nextRoute: RouteHelper.loginScreen,
      child: MyCustomScaffold(
        pageTitle: MyStrings.resetPassword.tr,
        body: GetBuilder<ResetPasswordController>(
          builder: (controller) => SingleChildScrollView(
            child: CustomAppCard(
              showBorder: false,
              child: Form(
                key: formKey,
                child: Column(
                  mainAxisSize: MainAxisSize.min,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    const SizedBox(height: Dimensions.space30),
                    HeaderText(text: MyStrings.resetPassword.tr),
                    const SizedBox(height: Dimensions.space15),
                    DefaultText(
                        text: MyStrings.resetPassContent.tr,
                        textStyle: regularDefault.copyWith(
                            color: MyColor.getBodyTextColor()
                                .withValues(alpha: 0.8))),
                    const SizedBox(height: Dimensions.space15),
                    Focus(
                      onFocusChange: (hasFocus) {
                        controller.changePasswordFocus(hasFocus);
                      },
                      child: LabelTextField(
                        focusNode: controller.passwordFocusNode,
                        nextFocus: controller.confirmPasswordFocusNode,
                        hintText: MyStrings.enterNewPassword.tr,
                        labelText: MyStrings.password.tr,
                        isPassword: true,
                        textInputType: TextInputType.text,
                        controller: controller.passController,
                        validator: (value) {
                          return controller.validatePassword(value);
                        },
                        onChanged: (value) {
                          if (controller.checkPasswordStrength) {
                            controller.updateValidationList(value);
                          }
                          return;
                        },
                        prefixIcon: MyAssetImageWidget(
                          width: Dimensions.space20,
                          assetPath: MyIcons.password,
                          isSvg: true,
                          height: Dimensions.space20,
                          boxFit: BoxFit.scaleDown,
                        ),
                      ),
                    ),
                    const SizedBox(height: Dimensions.space15),
                    LabelTextField(
                      textInputAction: TextInputAction.done,
                      isPassword: true,
                      labelText: MyStrings.confirmPassword.tr,
                      controller: controller.confirmPassController,
                      hintText: MyStrings.enterConfirmPassword.tr,
                      onChanged: (value) {
                        return;
                      },
                      validator: (value) {
                        if (controller.passController.text.toLowerCase() !=
                            controller.confirmPassController.text
                                .toLowerCase()) {
                          return MyStrings.kMatchPassError.tr;
                        } else {
                          return null;
                        }
                      },
                      prefixIcon: MyAssetImageWidget(
                        width: Dimensions.space20,
                        assetPath: MyIcons.password,
                        isSvg: true,
                        height: Dimensions.space20,
                        boxFit: BoxFit.scaleDown,
                      ),
                    ),
                    const SizedBox(height: Dimensions.space35),
                    CustomElevatedBtn(
                      isLoading: controller.submitLoading,
                      text: MyStrings.submit.tr,
                      onTap: () {
                        if (formKey.currentState!.validate()) {
                          controller.resetPassword();
                        }
                      },
                    ),
                  ],
                ),
              ),
            ),
          ),
        ),
      ),
    );
  }
}
