import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/app/components/text/default_text.dart';
import 'package:ovosale/app/components/text/header_text.dart';
import 'package:ovosale/core/utils/dimensions.dart';
import 'package:ovosale/core/utils/my_color.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/core/utils/style.dart';
import 'package:ovosale/data/controller/auth/forget_password/forget_password_controller.dart';
import 'package:ovosale/data/repo/auth/login_repo.dart';

class ForgetPasswordScreen extends StatefulWidget {
  const ForgetPasswordScreen({super.key});

  @override
  State<ForgetPasswordScreen> createState() => _ForgetPasswordScreenState();
}

class _ForgetPasswordScreenState extends State<ForgetPasswordScreen> {
  final _formKey = GlobalKey<FormState>();

  @override
  void initState() {
    Get.put(LoginRepo());
    Get.put(ForgetPasswordController(loginRepo: Get.find()));

    super.initState();
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return MyCustomScaffold(
        pageTitle: MyStrings.forgetPassword.tr,
        body: GetBuilder<ForgetPasswordController>(
          builder: (auth) => SingleChildScrollView(
            child: CustomAppCard(
              showBorder: false,
              child: Form(
                key: _formKey,
                child: Column(
                  mainAxisSize: MainAxisSize.min,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    const SizedBox(height: Dimensions.space30),
                    HeaderText(text: MyStrings.recoverAccount.tr),
                    const SizedBox(height: 15),
                    DefaultText(
                        text: MyStrings.forgetPasswordSubText.tr,
                        textStyle: regularDefault.copyWith(
                            color: MyColor.getBodyTextColor()
                                .withValues(alpha: 0.8))),
                    const SizedBox(height: Dimensions.space40),
                    LabelTextField(
                      fillColor: Theme.of(context).scaffoldBackgroundColor,
                      labelText: MyStrings.usernameOrEmail.tr,
                      textInputType: TextInputType.emailAddress,
                      textInputAction: TextInputAction.done,
                      hintText: MyStrings.usernameOrEmail.tr,
                      controller: auth.emailOrUsernameController,
                      onChanged: (value) {
                        return;
                      },
                      validator: (value) {
                        if (auth.emailOrUsernameController.text.isEmpty) {
                          return MyStrings.enterEmailOrUserName.tr;
                        } else {
                          return null;
                        }
                      },
                      prefixIcon: Icon(
                        CupertinoIcons.mail,
                        color: MyColor.getPrimaryColor(),
                        size: Dimensions.inputIconSize + 2,
                      ),
                    ),
                    const SizedBox(height: Dimensions.space25),
                    CustomElevatedBtn(
                      isLoading: auth.submitLoading,
                      onTap: () {
                        if (_formKey.currentState!.validate()) {
                          auth.submitForgetPassCode();
                        }
                      },
                      text: MyStrings.submit.tr,
                    ),
                    const SizedBox(height: Dimensions.space40)
                  ],
                ),
              ),
            ),
          ),
        ));
  }
}
